/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.UnsupportedEncodingException;
import java.text.FieldPosition;
import java.text.NumberFormat;

public class StringUtil {
    private static final String ENCODING = "ISO-8859-1";

    private StringUtil() {
    }

    public static String format(String message, Object[] params) {
        int currentParamNumber = 0;
        StringBuffer formattedMessage = new StringBuffer();
        int i = 0;
        while (i < message.length()) {
            if (message.charAt(i) == '%') {
                if (currentParamNumber >= params.length) {
                    formattedMessage.append("?missing data?");
                } else if (params[currentParamNumber] instanceof Number && i + 1 < message.length()) {
                    i += StringUtil.matchOptionalFormatting((Number)params[currentParamNumber++], message.substring(i + 1), formattedMessage);
                } else {
                    formattedMessage.append(params[currentParamNumber++].toString());
                }
            } else if (message.charAt(i) == '\\' && i + 1 < message.length() && message.charAt(i + 1) == '%') {
                formattedMessage.append('%');
                ++i;
            } else {
                formattedMessage.append(message.charAt(i));
            }
            ++i;
        }
        return formattedMessage.toString();
    }

    public static String getFromCompressedUnicode(byte[] string, int offset, int len) {
        try {
            return new String(string, offset, len, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError();
        }
    }

    public static String getFromUnicode(byte[] string) {
        return StringUtil.getFromUnicode(string, 0, string.length / 2);
    }

    public static String getFromUnicode(byte[] string, int offset, int len) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (offset < 0 || offset >= string.length) {
            throw new ArrayIndexOutOfBoundsException("Illegal offset");
        }
        if (len < 0 || (string.length - offset) / 2 < len) {
            throw new IllegalArgumentException("Illegal length");
        }
        char[] chars = new char[len];
        int i = 0;
        while (i < chars.length) {
            chars[i] = (char)((string[offset + 2 * i] << 8) + string[offset + (2 * i + 1)]);
            ++i;
        }
        return new String(chars);
    }

    public static String getFromUnicodeHigh(byte[] string) {
        return StringUtil.getFromUnicodeHigh(string, 0, string.length / 2);
    }

    public static String getFromUnicodeHigh(byte[] string, int offset, int len) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (offset < 0 || offset >= string.length) {
            throw new ArrayIndexOutOfBoundsException("Illegal offset");
        }
        if (len < 0 || (string.length - offset) / 2 < len) {
            throw new IllegalArgumentException("Illegal length");
        }
        char[] chars = new char[len];
        int i = 0;
        while (i < chars.length) {
            chars[i] = (char)(string[offset + 2 * i] & 0xFF | string[offset + (2 * i + 1)] << 8);
            ++i;
        }
        return new String(chars);
    }

    public static String getPreferredEncoding() {
        return ENCODING;
    }

    private static int matchOptionalFormatting(Number number, String formatting, StringBuffer outputTo) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (0 < formatting.length() && Character.isDigit(formatting.charAt(0))) {
            numberFormat.setMinimumIntegerDigits(Integer.parseInt(formatting.charAt(0) + ""));
            if (2 < formatting.length() && formatting.charAt(1) == '.' && Character.isDigit(formatting.charAt(2))) {
                numberFormat.setMaximumFractionDigits(Integer.parseInt(formatting.charAt(2) + ""));
                numberFormat.format(number, outputTo, new FieldPosition(0));
                return 3;
            }
            numberFormat.format(number, outputTo, new FieldPosition(0));
            return 1;
        }
        if (0 < formatting.length() && formatting.charAt(0) == '.' && 1 < formatting.length() && Character.isDigit(formatting.charAt(1))) {
            numberFormat.setMaximumFractionDigits(Integer.parseInt(formatting.charAt(1) + ""));
            numberFormat.format(number, outputTo, new FieldPosition(0));
            return 2;
        }
        numberFormat.format(number, outputTo, new FieldPosition(0));
        return 1;
    }

    public static void putCompressedUnicode(String input, byte[] output, int offset) {
        int strlen = input.length();
        int k = 0;
        while (k < strlen) {
            output[offset + k] = (byte)input.charAt(k);
            ++k;
        }
    }

    public static void putUncompressedUnicode(String input, byte[] output, int offset) {
        int strlen = input.length();
        int k = 0;
        while (k < strlen) {
            char c = input.charAt(k);
            output[offset + 2 * k] = (byte)c;
            output[offset + 2 * k + 1] = (byte)(c >> 8);
            ++k;
        }
    }

    public static void putUncompressedUnicodeHigh(String input, byte[] output, int offset) {
        int strlen = input.length();
        int k = 0;
        while (k < strlen) {
            char c = input.charAt(k);
            output[offset + 2 * k] = (byte)(c >> 8);
            output[offset + 2 * k] = (byte)c;
            ++k;
        }
    }
}

