/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class HexRead {
    public static byte[] readData(InputStream stream, int eofChar) throws IOException {
        int characterCount = 0;
        byte b = 0;
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        boolean done = false;
        while (!done) {
            int count = stream.read();
            int baseChar = 97;
            if (count == eofChar) break;
            switch (count) {
                case 35: {
                    HexRead.readToEOL(stream);
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    b = (byte)(b << 4);
                    b = (byte)(b + (byte)(count - 48));
                    if (++characterCount != 2) break;
                    bytes.add(new Byte(b));
                    characterCount = 0;
                    b = 0;
                    break;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    baseChar = 65;
                }
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    b = (byte)(b << 4);
                    b = (byte)(b + (byte)(count + 10 - baseChar));
                    if (++characterCount != 2) break;
                    bytes.add(new Byte(b));
                    characterCount = 0;
                    b = 0;
                    break;
                }
                case -1: {
                    done = true;
                    break;
                }
            }
        }
        Byte[] polished = bytes.toArray(new Byte[0]);
        byte[] rval = new byte[polished.length];
        int j = 0;
        while (j < polished.length) {
            rval[j] = polished[j];
            ++j;
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readData(String filename, String section) throws IOException {
        FileInputStream stream;
        block11: {
            byte[] byArray;
            block12: {
                File file = new File(filename);
                stream = new FileInputStream(file);
                try {
                    StringBuffer sectionText = new StringBuffer();
                    boolean inSection = false;
                    int c = stream.read();
                    while (true) {
                        if (c == -1) {
                            break block11;
                        }
                        switch (c) {
                            case 91: {
                                inSection = true;
                                break;
                            }
                            case 10: 
                            case 13: {
                                inSection = false;
                                sectionText = new StringBuffer();
                                break;
                            }
                            case 93: {
                                inSection = false;
                                if (sectionText.toString().equals(section)) {
                                    byArray = HexRead.readData(stream, 91);
                                    Object var9_8 = null;
                                    break block12;
                                } else {
                                    sectionText = new StringBuffer();
                                    break;
                                }
                            }
                            default: {
                                if (!inSection) break;
                                sectionText.append((char)c);
                            }
                        }
                        c = stream.read();
                    }
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    stream.close();
                    throw throwable;
                }
            }
            stream.close();
            return byArray;
        }
        Object var9_9 = null;
        stream.close();
        throw new IOException("Section '" + section + "' not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readData(String filename) throws IOException {
        byte[] byArray;
        File file = new File(filename);
        FileInputStream stream = new FileInputStream(file);
        try {
            byArray = HexRead.readData(stream, -1);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            stream.close();
            throw throwable;
        }
        stream.close();
        return byArray;
    }

    public static byte[] readFromString(String data) throws IOException {
        return HexRead.readData(new ByteArrayInputStream(data.getBytes()), -1);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static void readToEOL(InputStream stream) throws IOException {
        int c = stream.read();
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                c = stream.read();
            }
            if (c == -1 || c == 10) break;
        } while (c != 13);
    }
}

