/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.property.Property;

public abstract class EntryNode
implements Entry {
    private DirectoryNode _parent;
    private Property _property;

    protected EntryNode(Property property, DirectoryNode parent) {
        this._property = property;
        this._parent = parent;
    }

    public boolean delete() {
        boolean rval = false;
        if (!this.isRoot() && this.isDeleteOK()) {
            rval = this._parent.deleteEntry(this);
        }
        return rval;
    }

    public String getName() {
        return this._property.getName();
    }

    public DirectoryEntry getParent() {
        return this._parent;
    }

    protected Property getProperty() {
        return this._property;
    }

    protected abstract boolean isDeleteOK();

    public boolean isDirectoryEntry() {
        return false;
    }

    public boolean isDocumentEntry() {
        return false;
    }

    protected boolean isRoot() {
        return this._parent == null;
    }

    public boolean renameTo(String newName) {
        boolean rval = false;
        if (!this.isRoot()) {
            rval = this._parent.changeName(this.getName(), newName);
        }
        return rval;
    }
}

