/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.record.HeaderRecord;

public class HSSFHeader {
    String center;
    HeaderRecord headerRecord;
    String left;
    String right;

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    protected HSSFHeader(HeaderRecord headerRecord) {
        block14: {
            String head;
            block13: {
                this.headerRecord = headerRecord;
                head = headerRecord.getHeader();
                if (!true) break block13;
                if (head == null) return;
                if (head.length() <= 1) break block14;
            }
            do {
                int pos = head.length();
                switch (head.substring(1, 2).charAt(0)) {
                    case 'L': {
                        if (head.indexOf("&C") >= 0) {
                            pos = Math.min(pos, head.indexOf("&C"));
                        }
                        if (head.indexOf("&R") >= 0) {
                            pos = Math.min(pos, head.indexOf("&R"));
                        }
                        this.left = head.substring(2, pos);
                        head = head.substring(pos);
                        break;
                    }
                    case 'C': {
                        if (head.indexOf("&L") >= 0) {
                            pos = Math.min(pos, head.indexOf("&L"));
                        }
                        if (head.indexOf("&R") >= 0) {
                            pos = Math.min(pos, head.indexOf("&R"));
                        }
                        this.center = head.substring(2, pos);
                        head = head.substring(pos);
                        break;
                    }
                    case 'R': {
                        if (head.indexOf("&C") >= 0) {
                            pos = Math.min(pos, head.indexOf("&C"));
                        }
                        if (head.indexOf("&L") >= 0) {
                            pos = Math.min(pos, head.indexOf("&L"));
                        }
                        this.right = head.substring(2, pos);
                        head = head.substring(pos);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (head == null) return;
            } while (head.length() > 1);
        }
    }

    private void createHeaderString() {
        this.headerRecord.setHeader("&C" + (this.center == null ? "" : this.center) + "&L" + (this.left == null ? "" : this.left) + "&R" + (this.right == null ? "" : this.right));
        this.headerRecord.setHeaderLength((byte)this.headerRecord.getHeader().length());
    }

    public static String date() {
        return "&D";
    }

    public static String file() {
        return "&F";
    }

    public static String font(String font, String style) {
        return "&\"" + font + "," + style + "\"";
    }

    public static String fontSize(short size) {
        return "&" + size;
    }

    public String getCenter() {
        return this.center;
    }

    public String getLeft() {
        return this.left;
    }

    public String getRight() {
        return this.right;
    }

    public static String numPages() {
        return "&N";
    }

    public static String page() {
        return "&P";
    }

    public void setCenter(String newCenter) {
        this.center = newCenter;
        this.createHeaderString();
    }

    public void setLeft(String newLeft) {
        this.left = newLeft;
        this.createHeaderString();
    }

    public void setRight(String newRight) {
        this.right = newRight;
        this.createHeaderString();
    }

    public static String tab() {
        return "&A";
    }

    public static String time() {
        return "&T";
    }
}

