/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class FontDetails {
    private Map charWidths = new HashMap();
    private String fontName;
    private int height;

    public FontDetails(String fontName, int height) {
        this.fontName = fontName;
        this.height = height;
    }

    public void addChar(char c, int width) {
        this.charWidths.put(new Character(c), new Integer(width));
    }

    public void addChars(char[] characters, int[] widths) {
        int i = 0;
        while (i < characters.length) {
            this.charWidths.put(new Character(characters[i]), new Integer(widths[i]));
            ++i;
        }
    }

    public static FontDetails create(String fontName, Properties fontMetricsProps) {
        String[] widthsStrArray;
        String heightStr = fontMetricsProps.getProperty("font." + fontName + ".height");
        String widthsStr = fontMetricsProps.getProperty("font." + fontName + ".widths");
        String charactersStr = fontMetricsProps.getProperty("font." + fontName + ".characters");
        int height = Integer.parseInt(heightStr);
        FontDetails d = new FontDetails(fontName, height);
        String[] charactersStrArray = FontDetails.split(charactersStr, ",", -1);
        if (charactersStrArray.length != (widthsStrArray = FontDetails.split(widthsStr, ",", -1)).length) {
            throw new RuntimeException("Number of characters does not number of widths for font " + fontName);
        }
        int i = 0;
        while (i < widthsStrArray.length) {
            if (charactersStrArray[i].length() != 0) {
                d.addChar(charactersStrArray[i].charAt(0), Integer.parseInt(widthsStrArray[i]));
            }
            ++i;
        }
        return d;
    }

    public int getCharWidth(char c) {
        Integer widthInteger = (Integer)this.charWidths.get(new Character(c));
        if (widthInteger == null && c != 'W') {
            return this.getCharWidth('W');
        }
        return widthInteger;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getHeight() {
        return this.height;
    }

    public int getStringWidth(String str) {
        int width = 0;
        int i = 0;
        while (i < str.length()) {
            width += this.getCharWidth(str.charAt(i));
            ++i;
        }
        return width;
    }

    private static String[] split(String text, String separator, int max) {
        StringTokenizer tok = new StringTokenizer(text, separator);
        int listSize = tok.countTokens();
        if (max != -1 && listSize > max) {
            listSize = max;
        }
        String[] list = new String[listSize];
        int i = 0;
        while (tok.hasMoreTokens()) {
            if (max != -1 && i == listSize - 1) {
                StringBuffer buf = new StringBuffer(text.length() * (listSize - i) / listSize);
                while (tok.hasMoreTokens()) {
                    buf.append(tok.nextToken());
                    if (!tok.hasMoreTokens()) continue;
                    buf.append(separator);
                }
                list[i] = buf.toString().trim();
                break;
            }
            list[i] = tok.nextToken().trim();
            ++i;
        }
        return list;
    }
}

