/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public class ReferencePtg
extends Ptg {
    private static final int SIZE = 5;
    private BitField colRelative;
    private short field_1_row;
    private short field_2_col;
    private BitField rowRelative = new BitField(32768);
    public static final byte sid = 36;

    public ReferencePtg(byte[] data, int offset) {
        this.colRelative = new BitField(16384);
        this.field_1_row = LittleEndian.getShort(data, ++offset + 0);
        this.field_2_col = LittleEndian.getShort(data, offset + 2);
    }

    public ReferencePtg(String cellref) {
        this.colRelative = new BitField(16384);
        CellReference c = new CellReference(cellref);
        this.setRow((short)c.getRow());
        this.setColumn(c.getCol());
        this.setColRelative(!c.isColAbsolute());
        this.setRowRelative(!c.isRowAbsolute());
    }

    private ReferencePtg() {
        this.colRelative = new BitField(16384);
    }

    public Object clone() {
        ReferencePtg ptg = new ReferencePtg();
        ptg.field_1_row = this.field_1_row;
        ptg.field_2_col = this.field_2_col;
        ptg.setClass(this.ptgClass);
        return ptg;
    }

    public short getColumn() {
        return this.rowRelative.setShortBoolean(this.colRelative.setShortBoolean(this.field_2_col, false), false);
    }

    public short getColumnRaw() {
        return this.field_2_col;
    }

    public byte getDefaultOperandClass() {
        return 0;
    }

    public short getRow() {
        return this.field_1_row;
    }

    public int getSize() {
        return 5;
    }

    public boolean isColRelative() {
        return this.colRelative.isSet(this.field_2_col);
    }

    public boolean isRowRelative() {
        return this.rowRelative.isSet(this.field_2_col);
    }

    public void setColRelative(boolean rel) {
        this.field_2_col = this.colRelative.setShortBoolean(this.field_2_col, rel);
    }

    public void setColumn(short col) {
        this.field_2_col = col;
    }

    public void setColumnRaw(short col) {
        this.field_2_col = col;
    }

    public void setRow(short row) {
        this.field_1_row = row;
    }

    public void setRowRelative(boolean rel) {
        this.field_2_col = this.rowRelative.setShortBoolean(this.field_2_col, rel);
    }

    public String toFormulaString(Workbook book) {
        return new CellReference(this.getRow(), this.getColumn(), !this.isRowRelative(), !this.isColRelative()).toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[ValueReferencePtg]\n");
        buffer.append("row = ").append(this.getRow()).append("\n");
        buffer.append("col = ").append(this.getColumnRaw()).append("\n");
        buffer.append("rowrelative = ").append(this.isRowRelative()).append("\n");
        buffer.append("colrelative = ").append(this.isColRelative()).append("\n");
        return buffer.toString();
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset] = (byte)(36 + this.ptgClass);
        LittleEndian.putShort(array, offset + 1, this.field_1_row);
        LittleEndian.putShort(array, offset + 3, this.field_2_col);
    }
}

