/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.util.LittleEndian;

public class IntPtg
extends Ptg {
    public static final int SIZE = 3;
    private short field_1_value;
    public static final byte sid = 30;
    private int strlen = 0;
    private String val;

    public IntPtg(String formulaToken) {
        this.setValue(Short.parseShort(formulaToken));
    }

    public IntPtg(byte[] data, int offset) {
        this.setValue(LittleEndian.getShort(data, offset + 1));
    }

    private IntPtg() {
    }

    public Object clone() {
        IntPtg ptg = new IntPtg();
        ptg.field_1_value = this.field_1_value;
        return ptg;
    }

    public byte getDefaultOperandClass() {
        return 32;
    }

    public int getSize() {
        return 3;
    }

    public short getValue() {
        return this.field_1_value;
    }

    public void setValue(short value) {
        this.field_1_value = value;
    }

    public String toFormulaString(Workbook book) {
        return "" + this.getValue();
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset + 0] = 30;
        LittleEndian.putShort(array, offset + 1, this.getValue());
    }
}

