/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.excel;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

public class PixelGrabber
implements ImageConsumer {
    private final int DONEBITS = 112;
    private final int GRABBEDBITS = 48;
    byte[] bytePixels;
    int dstH;
    int dstOff;
    int dstScan;
    int dstW;
    int dstX;
    int dstY;
    private int flags;
    private boolean grabbing;
    ColorModel imageModel;
    int[] intPixels;
    ImageProducer producer;

    public PixelGrabber(ImageProducer imageproducer, int i, int j, int k, int l, int[] ai, int i1, int j1) {
        this.producer = imageproducer;
        this.dstX = i;
        this.dstY = j;
        this.dstW = k;
        this.dstH = l;
        this.dstOff = i1;
        this.dstScan = j1;
        this.intPixels = ai;
    }

    public PixelGrabber(Image image, int i, int j, int k, int l, int[] ai, int i1, int j1) {
        this(image.getSource(), i, j, k, l, ai, i1, j1);
    }

    public synchronized void abortGrabbing() {
        this.imageComplete(4);
    }

    private void convertToRGB() {
        int i = this.dstW * this.dstH;
        int[] ai = new int[i];
        if (this.bytePixels != null) {
            int j = 0;
            while (j < i) {
                ai[j] = this.imageModel.getRGB(this.bytePixels[j] & 0xFF);
                ++j;
            }
        } else if (this.intPixels != null) {
            int k = 0;
            while (k < i) {
                ai[k] = this.imageModel.getRGB(this.intPixels[k]);
                ++k;
            }
        }
        this.bytePixels = null;
        this.intPixels = ai;
        this.dstScan = this.dstW;
        this.dstOff = 0;
    }

    public synchronized ColorModel getColorModel() {
        return this.imageModel;
    }

    public synchronized int getHeight() {
        return this.dstH >= 0 ? this.dstH : -1;
    }

    public synchronized Object getPixels() {
        if (this.bytePixels != null) {
            return this.bytePixels;
        }
        return this.intPixels;
    }

    public synchronized int getStatus() {
        return this.flags;
    }

    public synchronized int getWidth() {
        return this.dstW >= 0 ? this.dstW : -1;
    }

    public synchronized boolean grabPixels(long l) throws InterruptedException {
        if ((this.flags & 0x70) != 0) {
            return (this.flags & 0x30) != 0;
        }
        long l1 = l + System.currentTimeMillis();
        if (!this.grabbing) {
            this.grabbing = true;
            this.flags &= 0xFFFFFF7F;
            this.producer.startProduction(this);
        }
        while (this.grabbing) {
            long l2;
            if (l == 0L) {
                l2 = 0L;
            } else {
                l2 = l1 - System.currentTimeMillis();
                if (l2 <= 0L) break;
            }
            this.wait(l2);
        }
        return (this.flags & 0x30) != 0;
    }

    public boolean grabPixels() throws InterruptedException {
        return this.grabPixels(0L);
    }

    public synchronized void imageComplete(int i) {
        this.grabbing = false;
        switch (i) {
            default: {
                this.flags |= 0xC0;
                break;
            }
            case 4: {
                this.flags |= 0x80;
                break;
            }
            case 3: {
                this.flags |= 0x20;
                break;
            }
            case 2: {
                this.flags |= 0x10;
            }
        }
        this.producer.removeConsumer(this);
        this.notifyAll();
    }

    public void setColorModel(ColorModel colormodel) {
    }

    public void setDimensions(int i, int j) {
        if (this.dstW < 0) {
            this.dstW = i - this.dstX;
        }
        if (this.dstH < 0) {
            this.dstH = j - this.dstY;
        }
        if (this.dstW <= 0 || this.dstH <= 0) {
            this.imageComplete(3);
        } else if (this.intPixels == null) {
            this.intPixels = new int[this.dstW * this.dstH];
            this.dstScan = this.dstW;
            this.dstOff = 0;
        }
        this.flags |= 3;
    }

    public void setHints(int i) {
    }

    public void setPixels(int i, int j, int k, int l, ColorModel colormodel, int[] ai, int i1, int j1) {
        if (j < this.dstY) {
            int k1 = this.dstY - j;
            if (k1 >= l) {
                return;
            }
            i1 += j1 * k1;
            j += k1;
            l -= k1;
        }
        if (j + l > this.dstY + this.dstH && (l = this.dstY + this.dstH - j) <= 0) {
            return;
        }
        if (i < this.dstX) {
            int l1 = this.dstX - i;
            if (l1 >= k) {
                return;
            }
            i1 += l1;
            i += l1;
            k -= l1;
        }
        if (i + k > this.dstX + this.dstW && (k = this.dstX + this.dstW - i) <= 0) {
            return;
        }
        if (this.intPixels == null) {
            if (this.bytePixels == null) {
                this.intPixels = new int[this.dstW * this.dstH];
                this.dstScan = this.dstW;
                this.dstOff = 0;
                this.imageModel = colormodel;
            } else {
                this.convertToRGB();
            }
        }
        int i2 = this.dstOff + (j - this.dstY) * this.dstScan + (i - this.dstX);
        if (this.imageModel == colormodel) {
            int j2 = l;
            while (j2 > 0) {
                System.arraycopy(ai, i1, this.intPixels, i2, k);
                i1 += j1;
                i2 += this.dstScan;
                --j2;
            }
        } else {
            int k2 = this.dstScan - k;
            int l2 = j1 - k;
            int i3 = l;
            while (i3 > 0) {
                int j3 = k;
                while (j3 > 0) {
                    this.intPixels[i2++] = colormodel.getRGB(ai[i1++]);
                    --j3;
                }
                i1 += l2;
                i2 += k2;
                --i3;
            }
        }
        this.flags |= 8;
    }

    public void setPixels(int i, int j, int k, int l, ColorModel colormodel, byte[] abyte0, int i1, int j1) {
        if (j < this.dstY) {
            int k1 = this.dstY - j;
            if (k1 >= l) {
                return;
            }
            i1 += j1 * k1;
            j += k1;
            l -= k1;
        }
        if (j + l > this.dstY + this.dstH && (l = this.dstY + this.dstH - j) <= 0) {
            return;
        }
        if (i < this.dstX) {
            int l1 = this.dstX - i;
            if (l1 >= k) {
                return;
            }
            i1 += l1;
            i += l1;
            k -= l1;
        }
        if (i + k > this.dstX + this.dstW && (k = this.dstX + this.dstW - i) <= 0) {
            return;
        }
        int i2 = this.dstOff + (j - this.dstY) * this.dstScan + (i - this.dstX);
        if (this.intPixels == null) {
            if (this.bytePixels == null) {
                this.bytePixels = new byte[this.dstW * this.dstH];
                this.dstScan = this.dstW;
                this.dstOff = 0;
                this.imageModel = colormodel;
            } else if (this.imageModel != colormodel) {
                this.convertToRGB();
            }
            if (this.bytePixels != null) {
                int j2 = l;
                while (j2 > 0) {
                    System.arraycopy(abyte0, i1, this.bytePixels, i2, k);
                    i1 += j1;
                    i2 += this.dstScan;
                    --j2;
                }
            }
        }
        if (this.intPixels != null) {
            int k2 = this.dstScan - k;
            int l2 = j1 - k;
            int i3 = l;
            while (i3 > 0) {
                int j3 = k;
                while (j3 > 0) {
                    this.intPixels[i2++] = colormodel.getRGB(abyte0[i1++] & 0xFF);
                    --j3;
                }
                i1 += l2;
                i2 += k2;
                --i3;
            }
        }
        this.flags |= 8;
    }

    public void setProperties(Hashtable hashtable) {
    }

    public synchronized void startGrabbing() {
        if ((this.flags & 0x70) != 0) {
            return;
        }
        if (!this.grabbing) {
            this.grabbing = true;
            this.flags &= 0xFFFFFF7F;
            this.producer.startProduction(this);
        }
    }

    public synchronized int status() {
        return this.flags;
    }
}

