/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.excel;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStreamLfirst
extends FilterOutputStream
implements DataOutput {
    protected int written;

    public DataOutputStreamLfirst(OutputStream outputstream) {
        super(outputstream);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    private void incCount(int i) {
        int j = this.written + i;
        if (j < 0) {
            j = Integer.MAX_VALUE;
        }
        this.written = j;
    }

    public final int size() {
        return this.written;
    }

    public synchronized void write(byte[] abyte0, int i, int j) throws IOException {
        this.out.write(abyte0, i, j);
        this.incCount(j);
    }

    public synchronized void write(int i) throws IOException {
        this.out.write(i);
        this.incCount(1);
    }

    public final void writeBoolean(boolean flag) throws IOException {
        this.out.write(flag ? 1 : 0);
        this.incCount(1);
    }

    public final void writeByte(int i) throws IOException {
        this.out.write(i);
        this.incCount(1);
    }

    public final void writeBytes(String s) throws IOException {
        OutputStream outputstream = this.out;
        int i = s.length();
        int j = 0;
        while (j < i) {
            outputstream.write((byte)s.charAt(j));
            ++j;
        }
        this.incCount(i);
    }

    public final void writeChar(int i) throws IOException {
        OutputStream outputstream = this.out;
        outputstream.write(i >>> 0 & 0xFF);
        outputstream.write(i >>> 8 & 0xFF);
        this.incCount(2);
    }

    public final void writeChars(String s) throws IOException {
        OutputStream outputstream = this.out;
        int i = s.length();
        int j = 0;
        while (j < i) {
            char c = s.charAt(j);
            outputstream.write(c >>> 0 & 0xFF);
            outputstream.write(c >>> 8 & 0xFF);
            ++j;
        }
        this.incCount(i * 2);
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeInt(int i) throws IOException {
        OutputStream outputstream = this.out;
        outputstream.write(i >>> 0 & 0xFF);
        outputstream.write(i >>> 8 & 0xFF);
        outputstream.write(i >>> 16 & 0xFF);
        outputstream.write(i >>> 24 & 0xFF);
        this.incCount(4);
    }

    public final void writeLong(long l) throws IOException {
        OutputStream outputstream = this.out;
        outputstream.write((int)(l >>> 0) & 0xFF);
        outputstream.write((int)(l >>> 8) & 0xFF);
        outputstream.write((int)(l >>> 16) & 0xFF);
        outputstream.write((int)(l >>> 24) & 0xFF);
        outputstream.write((int)(l >>> 32) & 0xFF);
        outputstream.write((int)(l >>> 40) & 0xFF);
        outputstream.write((int)(l >>> 48) & 0xFF);
        outputstream.write((int)(l >>> 56) & 0xFF);
        this.incCount(8);
    }

    public final void writeShort(int i) throws IOException {
        OutputStream outputstream = this.out;
        outputstream.write(i >>> 0 & 0xFF);
        outputstream.write(i >>> 8 & 0xFF);
        this.incCount(2);
    }

    static int writeUTF(String s, DataOutput dataoutput) throws IOException {
        int i = s.length();
        int j = 0;
        char[] ac = new char[i];
        int k = 0;
        s.getChars(0, i, ac, 0);
        int l = 0;
        while (l < i) {
            char c = ac[l];
            j = c >= '\u0001' && c <= '\u007f' ? ++j : (c > '\u07ff' ? (j += 3) : (j += 2));
            ++l;
        }
        if (j > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] abyte0 = new byte[j + 2];
        abyte0[k++] = (byte)(j >>> 0 & 0xFF);
        abyte0[k++] = (byte)(j >>> 8 & 0xFF);
        int i1 = 0;
        while (i1 < i) {
            char c1 = ac[i1];
            if (c1 >= '\u0001' && c1 <= '\u007f') {
                abyte0[k++] = (byte)c1;
            } else if (c1 > '\u07ff') {
                abyte0[k++] = (byte)(0x80 | c1 >> 0 & 0x3F);
                abyte0[k++] = (byte)(0x80 | c1 >> 6 & 0x3F);
                abyte0[k++] = (byte)(0xE0 | c1 >> 12 & 0xF);
            } else {
                abyte0[k++] = (byte)(0x80 | c1 >> 0 & 0x3F);
                abyte0[k++] = (byte)(0xC0 | c1 >> 6 & 0x1F);
            }
            ++i1;
        }
        dataoutput.write(abyte0);
        return j + 2;
    }

    public final void writeUTF(String s) throws IOException {
        DataOutputStreamLfirst.writeUTF(s, this);
    }
}

