/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class VCenterRecord
extends Record {
    private short field_1_vcenter;
    public static final short sid = 132;

    public VCenterRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public VCenterRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public VCenterRecord() {
    }

    public Object clone() {
        VCenterRecord rec = new VCenterRecord();
        rec.field_1_vcenter = this.field_1_vcenter;
        return rec;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_vcenter = LittleEndian.getShort(data, 0 + offset);
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 132;
    }

    public boolean getVCenter() {
        return this.field_1_vcenter == 1;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)132);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.field_1_vcenter);
        return this.getRecordSize();
    }

    public void setVCenter(boolean hc) {
        this.field_1_vcenter = hc ? (short)1 : 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[VCENTER]\n");
        buffer.append("    .vcenter        = ").append(this.getVCenter()).append("\n");
        buffer.append("[/VCENTER]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 132) {
            throw new RecordFormatException("NOT A VCenter RECORD");
        }
    }
}

