/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class SelectionRecord
extends Record {
    private byte field_1_pane;
    private int field_2_row_active_cell;
    private short field_3_col_active_cell;
    private short field_4_ref_active_cell;
    private short field_5_num_refs;
    private ArrayList field_6_refs;
    public static final short sid = 29;

    public SelectionRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public SelectionRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public SelectionRecord() {
    }

    public Object clone() {
        SelectionRecord rec = new SelectionRecord();
        rec.field_1_pane = this.field_1_pane;
        rec.field_2_row_active_cell = this.field_2_row_active_cell;
        rec.field_3_col_active_cell = this.field_3_col_active_cell;
        rec.field_4_ref_active_cell = this.field_4_ref_active_cell;
        rec.field_5_num_refs = this.field_5_num_refs;
        rec.field_6_refs = this.field_6_refs;
        return rec;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_pane = data[0 + offset];
        this.field_2_row_active_cell = LittleEndian.getUShort(data, 1 + offset);
        this.field_3_col_active_cell = LittleEndian.getShort(data, 3 + offset);
        this.field_4_ref_active_cell = LittleEndian.getShort(data, 5 + offset);
        this.field_5_num_refs = LittleEndian.getShort(data, 7 + offset);
    }

    public short getActiveCellCol() {
        return this.field_3_col_active_cell;
    }

    public short getActiveCellRef() {
        return this.field_4_ref_active_cell;
    }

    public int getActiveCellRow() {
        return this.field_2_row_active_cell;
    }

    public short getNumRefs() {
        return this.field_5_num_refs;
    }

    public byte getPane() {
        return this.field_1_pane;
    }

    public int getRecordSize() {
        return 19;
    }

    public short getSid() {
        return 29;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)29);
        LittleEndian.putShort(data, 2 + offset, (short)15);
        data[4 + offset] = this.getPane();
        LittleEndian.putShort(data, 5 + offset, (short)this.getActiveCellRow());
        LittleEndian.putShort(data, 7 + offset, this.getActiveCellCol());
        LittleEndian.putShort(data, 9 + offset, this.getActiveCellRef());
        LittleEndian.putShort(data, 11 + offset, (short)1);
        LittleEndian.putShort(data, 13 + offset, (short)this.getActiveCellRow());
        LittleEndian.putShort(data, 15 + offset, (short)this.getActiveCellRow());
        data[17 + offset] = (byte)this.getActiveCellCol();
        data[18 + offset] = (byte)this.getActiveCellCol();
        return this.getRecordSize();
    }

    public void setActiveCellCol(short col) {
        this.field_3_col_active_cell = col;
    }

    public void setActiveCellRef(short ref) {
        this.field_4_ref_active_cell = ref;
    }

    public void setActiveCellRow(int row) {
        this.field_2_row_active_cell = row;
    }

    public void setNumRefs(short refs) {
        this.field_5_num_refs = refs;
    }

    public void setPane(byte pane) {
        this.field_1_pane = pane;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SELECTION]\n");
        buffer.append("    .pane            = ").append(Integer.toHexString(this.getPane())).append("\n");
        buffer.append("    .activecellrow   = ").append(Integer.toHexString(this.getActiveCellRow())).append("\n");
        buffer.append("    .activecellcol   = ").append(Integer.toHexString(this.getActiveCellCol())).append("\n");
        buffer.append("    .activecellref   = ").append(Integer.toHexString(this.getActiveCellRef())).append("\n");
        buffer.append("    .numrefs         = ").append(Integer.toHexString(this.getNumRefs())).append("\n");
        buffer.append("[/SELECTION]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 29) {
            throw new RecordFormatException("NOT A valid Selection RECORD");
        }
    }
}

