/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Margin;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class RightMarginRecord
extends Record
implements Margin {
    private double field_1_margin;
    public static final short sid = 39;

    public RightMarginRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public RightMarginRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public RightMarginRecord() {
    }

    public Object clone() {
        RightMarginRecord rec = new RightMarginRecord();
        rec.field_1_margin = this.field_1_margin;
        return rec;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_margin = LittleEndian.getDouble(data, 0 + offset);
    }

    public double getMargin() {
        return this.field_1_margin;
    }

    public int getRecordSize() {
        return 12;
    }

    public short getSid() {
        return 39;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)39);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putDouble(data, 4 + offset, this.field_1_margin);
        return this.getRecordSize();
    }

    public void setMargin(double field_1_margin) {
        this.field_1_margin = field_1_margin;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[RightMargin]\n");
        buffer.append("    .margin               = ").append(" (").append(this.getMargin()).append(" )\n");
        buffer.append("[/RightMargin]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 39) {
            throw new RecordFormatException("Not a RightMargin record");
        }
    }
}

