/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

public abstract class Record {
    public Record(short id, short size, byte[] data, int offset) {
        this.validateSid(id);
        this.fillFields(data, size, offset);
    }

    public Record(short id, short size, byte[] data) {
        this.validateSid(id);
        this.fillFields(data, size);
    }

    public Record() {
    }

    public Object clone() {
        throw new RuntimeException("The class " + this.getClass().getName() + " needs to define a clone method");
    }

    protected abstract void fillFields(byte[] var1, short var2, int var3);

    protected void fillFields(byte[] data, short size) {
        this.fillFields(data, size, 0);
    }

    public int getRecordSize() {
        return this.serialize().length;
    }

    public abstract short getSid();

    public boolean isInValueSection() {
        return false;
    }

    public boolean isValue() {
        return false;
    }

    public void processContinueRecord(byte[] record) {
    }

    public abstract int serialize(int var1, byte[] var2);

    public byte[] serialize() {
        byte[] retval = new byte[this.getRecordSize()];
        this.serialize(0, retval);
        return retval;
    }

    public String toString() {
        return super.toString();
    }

    protected abstract void validateSid(short var1);
}

