/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public class PrintSetupRecord
extends Record {
    private static final BitField draft;
    private double field_10_footermargin;
    private short field_11_copies;
    private short field_1_paper_size;
    private short field_2_scale;
    private short field_3_page_start;
    private short field_4_fit_width;
    private short field_5_fit_height;
    private short field_6_options;
    private short field_7_hresolution;
    private short field_8_vresolution;
    private double field_9_headermargin;
    private static final BitField landscape;
    private static final BitField lefttoright;
    private static final BitField noOrientation;
    private static final BitField nocolor;
    private static final BitField notes;
    public static final short sid = 161;
    private static final BitField usepage;
    private static final BitField validsettings;

    static {
        lefttoright = new BitField(1);
        landscape = new BitField(2);
        validsettings = new BitField(4);
        nocolor = new BitField(8);
        draft = new BitField(16);
        notes = new BitField(32);
        noOrientation = new BitField(64);
        usepage = new BitField(128);
    }

    public PrintSetupRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public PrintSetupRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public PrintSetupRecord() {
    }

    public Object clone() {
        PrintSetupRecord rec = new PrintSetupRecord();
        rec.field_1_paper_size = this.field_1_paper_size;
        rec.field_2_scale = this.field_2_scale;
        rec.field_3_page_start = this.field_3_page_start;
        rec.field_4_fit_width = this.field_4_fit_width;
        rec.field_5_fit_height = this.field_5_fit_height;
        rec.field_6_options = this.field_6_options;
        rec.field_7_hresolution = this.field_7_hresolution;
        rec.field_8_vresolution = this.field_8_vresolution;
        rec.field_9_headermargin = this.field_9_headermargin;
        rec.field_10_footermargin = this.field_10_footermargin;
        rec.field_11_copies = this.field_11_copies;
        return rec;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_paper_size = LittleEndian.getShort(data, 0 + offset);
        this.field_2_scale = LittleEndian.getShort(data, 2 + offset);
        this.field_3_page_start = LittleEndian.getShort(data, 4 + offset);
        this.field_4_fit_width = LittleEndian.getShort(data, 6 + offset);
        this.field_5_fit_height = LittleEndian.getShort(data, 8 + offset);
        this.field_6_options = LittleEndian.getShort(data, 10 + offset);
        this.field_7_hresolution = LittleEndian.getShort(data, 12 + offset);
        this.field_8_vresolution = LittleEndian.getShort(data, 14 + offset);
        this.field_9_headermargin = LittleEndian.getDouble(data, 16 + offset);
        this.field_10_footermargin = LittleEndian.getDouble(data, 24 + offset);
        this.field_11_copies = LittleEndian.getShort(data, 32 + offset);
    }

    public short getCopies() {
        return this.field_11_copies;
    }

    public boolean getDraft() {
        return draft.isSet(this.field_6_options);
    }

    public short getFitHeight() {
        return this.field_5_fit_height;
    }

    public short getFitWidth() {
        return this.field_4_fit_width;
    }

    public double getFooterMargin() {
        return this.field_10_footermargin;
    }

    public short getHResolution() {
        return this.field_7_hresolution;
    }

    public double getHeaderMargin() {
        return this.field_9_headermargin;
    }

    public boolean getLandscape() {
        return landscape.isSet(this.field_6_options);
    }

    public boolean getLeftToRight() {
        return lefttoright.isSet(this.field_6_options);
    }

    public boolean getNoColor() {
        return nocolor.isSet(this.field_6_options);
    }

    public boolean getNoOrientation() {
        return noOrientation.isSet(this.field_6_options);
    }

    public boolean getNotes() {
        return notes.isSet(this.field_6_options);
    }

    public short getOptions() {
        return this.field_6_options;
    }

    public short getPageStart() {
        return this.field_3_page_start;
    }

    public short getPaperSize() {
        return this.field_1_paper_size;
    }

    public int getRecordSize() {
        return 38;
    }

    public short getScale() {
        return this.field_2_scale;
    }

    public short getSid() {
        return 161;
    }

    public boolean getUsePage() {
        return usepage.isSet(this.field_6_options);
    }

    public short getVResolution() {
        return this.field_8_vresolution;
    }

    public boolean getValidSettings() {
        return validsettings.isSet(this.field_6_options);
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)161);
        LittleEndian.putShort(data, 2 + offset, (short)34);
        LittleEndian.putShort(data, 4 + offset, this.getPaperSize());
        LittleEndian.putShort(data, 6 + offset, this.getScale());
        LittleEndian.putShort(data, 8 + offset, this.getPageStart());
        LittleEndian.putShort(data, 10 + offset, this.getFitWidth());
        LittleEndian.putShort(data, 12 + offset, this.getFitHeight());
        LittleEndian.putShort(data, 14 + offset, this.getOptions());
        LittleEndian.putShort(data, 16 + offset, this.getHResolution());
        LittleEndian.putShort(data, 18 + offset, this.getVResolution());
        LittleEndian.putDouble(data, 20 + offset, this.getHeaderMargin());
        LittleEndian.putDouble(data, 28 + offset, this.getFooterMargin());
        LittleEndian.putShort(data, 36 + offset, this.getCopies());
        return this.getRecordSize();
    }

    public void setCopies(short copies) {
        this.field_11_copies = copies;
    }

    public void setDraft(boolean d) {
        this.field_6_options = draft.setShortBoolean(this.field_6_options, d);
    }

    public void setFitHeight(short height) {
        this.field_5_fit_height = height;
    }

    public void setFitWidth(short width) {
        this.field_4_fit_width = width;
    }

    public void setFooterMargin(double footermargin) {
        this.field_10_footermargin = footermargin;
    }

    public void setHResolution(short resolution) {
        this.field_7_hresolution = resolution;
    }

    public void setHeaderMargin(double headermargin) {
        this.field_9_headermargin = headermargin;
    }

    public void setLandscape(boolean ls) {
        this.field_6_options = landscape.setShortBoolean(this.field_6_options, ls);
    }

    public void setLeftToRight(boolean ltor) {
        this.field_6_options = lefttoright.setShortBoolean(this.field_6_options, ltor);
    }

    public void setNoColor(boolean mono) {
        this.field_6_options = nocolor.setShortBoolean(this.field_6_options, mono);
    }

    public void setNoOrientation(boolean orientation) {
        this.field_6_options = noOrientation.setShortBoolean(this.field_6_options, orientation);
    }

    public void setNotes(boolean printnotes) {
        this.field_6_options = notes.setShortBoolean(this.field_6_options, printnotes);
    }

    public void setOptions(short options) {
        this.field_6_options = options;
    }

    public void setPageStart(short start) {
        this.field_3_page_start = start;
    }

    public void setPaperSize(short size) {
        this.field_1_paper_size = size;
    }

    public void setScale(short scale) {
        this.field_2_scale = scale;
    }

    public void setUsePage(boolean page) {
        this.field_6_options = usepage.setShortBoolean(this.field_6_options, page);
    }

    public void setVResolution(short resolution) {
        this.field_8_vresolution = resolution;
    }

    public void setValidSettings(boolean valid) {
        this.field_6_options = validsettings.setShortBoolean(this.field_6_options, valid);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[PRINTSETUP]\n");
        buffer.append("    .papersize      = ").append(this.getPaperSize()).append("\n");
        buffer.append("    .scale          = ").append(this.getScale()).append("\n");
        buffer.append("    .pagestart      = ").append(this.getPageStart()).append("\n");
        buffer.append("    .fitwidth       = ").append(this.getFitWidth()).append("\n");
        buffer.append("    .fitheight      = ").append(this.getFitHeight()).append("\n");
        buffer.append("    .options        = ").append(this.getOptions()).append("\n");
        buffer.append("        .ltor       = ").append(this.getLeftToRight()).append("\n");
        buffer.append("        .landscape  = ").append(this.getLandscape()).append("\n");
        buffer.append("        .valid      = ").append(this.getValidSettings()).append("\n");
        buffer.append("        .mono       = ").append(this.getNoColor()).append("\n");
        buffer.append("        .draft      = ").append(this.getDraft()).append("\n");
        buffer.append("        .notes      = ").append(this.getNotes()).append("\n");
        buffer.append("        .noOrientat = ").append(this.getNoOrientation()).append("\n");
        buffer.append("        .usepage    = ").append(this.getUsePage()).append("\n");
        buffer.append("    .hresolution    = ").append(this.getHResolution()).append("\n");
        buffer.append("    .vresolution    = ").append(this.getVResolution()).append("\n");
        buffer.append("    .headermargin   = ").append(this.getHeaderMargin()).append("\n");
        buffer.append("    .footermargin   = ").append(this.getFooterMargin()).append("\n");
        buffer.append("    .copies         = ").append(this.getCopies()).append("\n");
        buffer.append("[/PRINTSETUP]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 161) {
            throw new RecordFormatException("NOT A valid PrintSetup record RECORD");
        }
    }
}

