/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class PasswordRev4Record
extends Record {
    private short field_1_password;
    public static final short sid = 444;

    public PasswordRev4Record(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public PasswordRev4Record(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public PasswordRev4Record() {
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_password = LittleEndian.getShort(data, 0 + offset);
    }

    public short getPassword() {
        return this.field_1_password;
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 444;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)444);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.getPassword());
        return this.getRecordSize();
    }

    public void setPassword(short pw) {
        this.field_1_password = pw;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[PROT4REVPASSWORD]\n");
        buffer.append("    .password       = ").append(Integer.toHexString(this.getPassword())).append("\n");
        buffer.append("[/PROT4REVPASSWORD]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 444) {
            throw new RecordFormatException("NOT A PROT4REVPASSWORD RECORD");
        }
    }
}

