/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.SubRecord;
import org.apache.poi.util.LittleEndian;

public class ObjRecord
extends Record {
    public static final short sid = 93;
    private List subrecords;

    public ObjRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public ObjRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public ObjRecord() {
        this.subrecords = new ArrayList(2);
    }

    public boolean addSubRecord(Object o) {
        return this.subrecords.add(o);
    }

    public void addSubRecord(int index, Object element) {
        this.subrecords.add(index, element);
    }

    public void clearSubRecords() {
        this.subrecords.clear();
    }

    public Object clone() {
        ObjRecord rec = new ObjRecord();
        rec.subrecords = new ArrayList();
        Iterator iterator = this.subrecords.iterator();
        while (iterator.hasNext()) {
            this.subrecords.add(((Record)iterator.next()).clone());
        }
        return rec;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.subrecords = new ArrayList();
        int pos = offset;
        while (pos - offset < size) {
            short subRecordSid = LittleEndian.getShort(data, pos);
            short subRecordSize = LittleEndian.getShort(data, pos + 2);
            Record subRecord = SubRecord.createSubRecord(subRecordSid, subRecordSize, data, pos + 4);
            this.subrecords.add(subRecord);
            pos += 4 + subRecordSize;
        }
    }

    public int getRecordSize() {
        int size = 0;
        Iterator iterator = this.subrecords.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            size += record.getRecordSize();
        }
        return 4 + size;
    }

    public short getSid() {
        return 93;
    }

    public List getSubRecords() {
        return this.subrecords;
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)93);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        pos = offset + 4;
        Iterator iterator = this.subrecords.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            pos += record.serialize(pos, data);
        }
        return this.getRecordSize();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[OBJ]\n");
        Iterator iterator = this.subrecords.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            buffer.append("SUBRECORD: " + record.toString());
        }
        buffer.append("[/OBJ]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 93) {
            throw new RecordFormatException("Not an OBJ record");
        }
    }
}

