/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class NumberFormatIndexRecord
extends Record {
    private short field_1_formatIndex;
    public static final short sid = 4174;

    public NumberFormatIndexRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public NumberFormatIndexRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public NumberFormatIndexRecord() {
    }

    public Object clone() {
        NumberFormatIndexRecord rec = new NumberFormatIndexRecord();
        rec.field_1_formatIndex = this.field_1_formatIndex;
        return rec;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        int pos = 0;
        this.field_1_formatIndex = LittleEndian.getShort(data, pos + 0 + offset);
    }

    public short getFormatIndex() {
        return this.field_1_formatIndex;
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 4174;
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4174);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset + pos, this.field_1_formatIndex);
        return this.getRecordSize();
    }

    public void setFormatIndex(short field_1_formatIndex) {
        this.field_1_formatIndex = field_1_formatIndex;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[IFMT]\n");
        buffer.append("    .formatIndex          = ").append("0x").append(HexDump.toHex(this.getFormatIndex())).append(" (").append(this.getFormatIndex()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/IFMT]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 4174) {
            throw new RecordFormatException("Not a NumberFormatIndex record");
        }
    }
}

