/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.BitField;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class FrameRecord
extends Record {
    public static final short BORDER_TYPE_REGULAR = 0;
    public static final short BORDER_TYPE_SHADOW = 1;
    private BitField autoPosition;
    private BitField autoSize = new BitField(1);
    private short field_1_borderType;
    private short field_2_options;
    public static final short sid = 4146;

    public FrameRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
        this.autoPosition = new BitField(2);
    }

    public FrameRecord(short id, short size, byte[] data) {
        super(id, size, data);
        this.autoPosition = new BitField(2);
    }

    public FrameRecord() {
        this.autoPosition = new BitField(2);
    }

    public Object clone() {
        FrameRecord rec = new FrameRecord();
        rec.field_1_borderType = this.field_1_borderType;
        rec.field_2_options = this.field_2_options;
        return rec;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        int pos = 0;
        this.field_1_borderType = LittleEndian.getShort(data, pos + 0 + offset);
        this.field_2_options = LittleEndian.getShort(data, pos + 2 + offset);
    }

    public short getBorderType() {
        return this.field_1_borderType;
    }

    public short getOptions() {
        return this.field_2_options;
    }

    public int getRecordSize() {
        return 8;
    }

    public short getSid() {
        return 4146;
    }

    public boolean isAutoPosition() {
        return this.autoPosition.isSet(this.field_2_options);
    }

    public boolean isAutoSize() {
        return this.autoSize.isSet(this.field_2_options);
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4146);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset + pos, this.field_1_borderType);
        LittleEndian.putShort(data, 6 + offset + pos, this.field_2_options);
        return this.getRecordSize();
    }

    public void setAutoPosition(boolean value) {
        this.field_2_options = this.autoPosition.setShortBoolean(this.field_2_options, value);
    }

    public void setAutoSize(boolean value) {
        this.field_2_options = this.autoSize.setShortBoolean(this.field_2_options, value);
    }

    public void setBorderType(short field_1_borderType) {
        this.field_1_borderType = field_1_borderType;
    }

    public void setOptions(short field_2_options) {
        this.field_2_options = field_2_options;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FRAME]\n");
        buffer.append("    .borderType           = ").append("0x").append(HexDump.toHex(this.getBorderType())).append(" (").append(this.getBorderType()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .autoSize                 = ").append(this.isAutoSize()).append('\n');
        buffer.append("         .autoPosition             = ").append(this.isAutoPosition()).append('\n');
        buffer.append("[/FRAME]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 4146) {
            throw new RecordFormatException("Not a Frame record");
        }
    }
}

