/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.PwdUtils;

public class FilePassRecord
extends Record {
    private short field_1_key;
    private short field_2_hash;
    private String pwdString = null;
    public static final short sid = 47;

    public FilePassRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public FilePassRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public FilePassRecord() {
    }

    public Object clone() {
        return super.clone();
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_key = LittleEndian.getShort(data, 2 + offset);
        this.field_2_hash = LittleEndian.getShort(data, 4 + offset);
    }

    public short getHash() {
        return this.field_2_hash;
    }

    public short getKey() {
        return this.field_1_key;
    }

    public String getPassword() {
        return this.pwdString;
    }

    public int getRecordSize() {
        return 10;
    }

    public short getSid() {
        return 47;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)47);
        LittleEndian.putShort(data, 2 + offset, (short)6);
        LittleEndian.putShort(data, 4 + offset, (short)0);
        LittleEndian.putShort(data, 6 + offset, this.getKey());
        LittleEndian.putShort(data, 8 + offset, this.getHash());
        return this.getRecordSize();
    }

    public void setHash(short hash) {
        this.field_2_hash = hash;
    }

    public void setKey(short key) {
        this.field_1_key = key;
    }

    public void setPassword(String pwdString) {
        this.pwdString = pwdString;
        byte[] bb = pwdString.getBytes();
        this.setKey(PwdUtils.getEncryptionKey(bb));
        this.setHash(PwdUtils.getPasswordHash(bb));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FILEPASS]\n");
        buffer.append("    .key            = ").append(Integer.toHexString(this.getKey())).append("\n");
        buffer.append("    .hash           = ").append(Integer.toHexString(this.getHash())).append("\n");
        buffer.append("[/FILEPASS]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 47) {
            throw new RecordFormatException("NOT A FILEPASS RECORD");
        }
    }
}

