/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class DefaultColWidthRecord
extends Record {
    private short field_1_col_width;
    public static final short sid = 85;

    public DefaultColWidthRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public DefaultColWidthRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public DefaultColWidthRecord() {
    }

    public Object clone() {
        DefaultColWidthRecord rec = new DefaultColWidthRecord();
        rec.field_1_col_width = this.field_1_col_width;
        return rec;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_col_width = LittleEndian.getShort(data, 0 + offset);
    }

    public short getColWidth() {
        return this.field_1_col_width;
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 85;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)85);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.getColWidth());
        return this.getRecordSize();
    }

    public void setColWidth(short height) {
        this.field_1_col_width = height;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[DEFAULTCOLWIDTH]\n");
        buffer.append("    .colwidth      = ").append(Integer.toHexString(this.getColWidth())).append("\n");
        buffer.append("[/DEFAULTCOLWIDTH]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 85) {
            throw new RecordFormatException("NOT A DefaultColWidth RECORD");
        }
    }
}

