/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Margin;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class BottomMarginRecord
extends Record
implements Margin {
    private double field_1_margin;
    public static final short sid = 41;

    public BottomMarginRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public BottomMarginRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public BottomMarginRecord() {
    }

    public Object clone() {
        BottomMarginRecord rec = new BottomMarginRecord();
        rec.field_1_margin = this.field_1_margin;
        return rec;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_margin = LittleEndian.getDouble(data, 0 + offset);
    }

    public double getMargin() {
        return this.field_1_margin;
    }

    public int getRecordSize() {
        return 12;
    }

    public short getSid() {
        return 41;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)41);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putDouble(data, 4 + offset, this.field_1_margin);
        return this.getRecordSize();
    }

    public void setMargin(double field_1_margin) {
        this.field_1_margin = field_1_margin;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[BottomMargin]\n");
        buffer.append("    .margin               = ").append(" (").append(this.getMargin()).append(" )\n");
        buffer.append("[/BottomMargin]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 41) {
            throw new RecordFormatException("Not a BottomMargin record");
        }
    }
}

