/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class BoolErrRecord
extends Record
implements CellValueRecordInterface,
Comparable {
    private int field_1_row;
    private short field_2_column;
    private short field_3_xf_index;
    private byte field_4_bBoolErr;
    private byte field_5_fError;
    public static final short sid = 517;

    public BoolErrRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public BoolErrRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public BoolErrRecord() {
    }

    public Object clone() {
        BoolErrRecord rec = new BoolErrRecord();
        rec.field_1_row = this.field_1_row;
        rec.field_2_column = this.field_2_column;
        rec.field_3_xf_index = this.field_3_xf_index;
        rec.field_4_bBoolErr = this.field_4_bBoolErr;
        rec.field_5_fError = this.field_5_fError;
        return rec;
    }

    public int compareTo(Object obj) {
        CellValueRecordInterface loc = (CellValueRecordInterface)obj;
        if (this.getRow() == loc.getRow() && this.getColumn() == loc.getColumn()) {
            return 0;
        }
        if (this.getRow() < loc.getRow()) {
            return -1;
        }
        if (this.getRow() > loc.getRow()) {
            return 1;
        }
        if (this.getColumn() < loc.getColumn()) {
            return -1;
        }
        if (this.getColumn() > loc.getColumn()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CellValueRecordInterface)) {
            return false;
        }
        CellValueRecordInterface loc = (CellValueRecordInterface)obj;
        return this.getRow() == loc.getRow() && this.getColumn() == loc.getColumn();
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_row = LittleEndian.getUShort(data, 0 + offset);
        this.field_2_column = LittleEndian.getShort(data, 2 + offset);
        this.field_3_xf_index = LittleEndian.getShort(data, 4 + offset);
        this.field_4_bBoolErr = data[6 + offset];
        this.field_5_fError = data[7 + offset];
    }

    public boolean getBooleanValue() {
        return this.field_4_bBoolErr != 0;
    }

    public short getColumn() {
        return this.field_2_column;
    }

    public byte getErrorValue() {
        return this.field_4_bBoolErr;
    }

    public int getRecordSize() {
        return 12;
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getSid() {
        return 517;
    }

    public short getXFIndex() {
        return this.field_3_xf_index;
    }

    public boolean isAfter(CellValueRecordInterface i) {
        if (this.getRow() < i.getRow()) {
            return false;
        }
        if (this.getRow() == i.getRow() && this.getColumn() < i.getColumn()) {
            return false;
        }
        return this.getRow() != i.getRow() || this.getColumn() != i.getColumn();
    }

    public boolean isBefore(CellValueRecordInterface i) {
        if (this.getRow() > i.getRow()) {
            return false;
        }
        if (this.getRow() == i.getRow() && this.getColumn() > i.getColumn()) {
            return false;
        }
        return this.getRow() != i.getRow() || this.getColumn() != i.getColumn();
    }

    public boolean isBoolean() {
        return this.field_5_fError == 0;
    }

    public boolean isEqual(CellValueRecordInterface i) {
        return this.getRow() == i.getRow() && this.getColumn() == i.getColumn();
    }

    public boolean isError() {
        return this.field_5_fError != 0;
    }

    public boolean isInValueSection() {
        return true;
    }

    public boolean isValue() {
        return true;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)517);
        LittleEndian.putShort(data, 2 + offset, (short)8);
        LittleEndian.putShort(data, 4 + offset, (short)this.getRow());
        LittleEndian.putShort(data, 6 + offset, this.getColumn());
        LittleEndian.putShort(data, 8 + offset, this.getXFIndex());
        data[10 + offset] = this.field_4_bBoolErr;
        data[11 + offset] = this.field_5_fError;
        return this.getRecordSize();
    }

    public void setColumn(short col) {
        this.field_2_column = col;
    }

    public void setError(boolean val) {
        this.field_5_fError = (byte)(val ? 1 : 0);
    }

    public void setRow(int row) {
        this.field_1_row = row;
    }

    public void setValue(byte value) {
        if (value != 0 && value != 7 && value != 15 && value != 23 && value != 29 && value != 36 && value != 42) {
            throw new RuntimeException("Error Value can only be 0,7,15,23,29,36 or 42. It cannot be " + value);
        }
        this.field_4_bBoolErr = value;
        this.field_5_fError = 1;
    }

    public void setValue(boolean value) {
        this.field_4_bBoolErr = value ? (byte)1 : 0;
        this.field_5_fError = 0;
    }

    public void setXFIndex(short xf) {
        this.field_3_xf_index = xf;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[BOOLERR]\n");
        buffer.append("    .row            = ").append(Integer.toHexString(this.getRow())).append("\n");
        buffer.append("    .col            = ").append(Integer.toHexString(this.getColumn())).append("\n");
        buffer.append("    .xfindex        = ").append(Integer.toHexString(this.getXFIndex())).append("\n");
        if (this.isBoolean()) {
            buffer.append("    .booleanValue   = ").append(this.getBooleanValue()).append("\n");
        } else {
            buffer.append("    .errorValue     = ").append(this.getErrorValue()).append("\n");
        }
        buffer.append("[/BOOLERR]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 517) {
            throw new RecordFormatException("Not a valid BoolErrRecord");
        }
    }
}

