/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import org.apache.poi.ddf.EscherClientAnchorRecord;
import org.apache.poi.ddf.EscherClientDataRecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.ddf.EscherTextboxRecord;
import org.apache.poi.hssf.model.AbstractShape;
import org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import org.apache.poi.hssf.record.EndSubRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.record.TextObjectRecord;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFSimpleShape;
import org.apache.poi.hssf.usermodel.HSSFTextbox;

public class TextboxShape
extends AbstractShape {
    private EscherTextboxRecord escherTextbox;
    private ObjRecord objRecord;
    private EscherContainerRecord spContainer;
    private TextObjectRecord textObjectRecord;

    TextboxShape(HSSFTextbox hssfShape, int shapeId) {
        this.spContainer = this.createSpContainer(hssfShape, shapeId);
        this.objRecord = this.createObjRecord(hssfShape, shapeId);
        this.textObjectRecord = this.createTextObjectRecord(hssfShape, shapeId);
    }

    private ObjRecord createObjRecord(HSSFTextbox hssfShape, int shapeId) {
        HSSFTextbox shape = hssfShape;
        ObjRecord obj = new ObjRecord();
        CommonObjectDataSubRecord c = new CommonObjectDataSubRecord();
        c.setObjectType((short)((HSSFSimpleShape)shape).getShapeType());
        c.setObjectId((short)shapeId);
        c.setLocked(true);
        c.setPrintable(true);
        c.setAutofill(true);
        c.setAutoline(true);
        EndSubRecord e = new EndSubRecord();
        obj.addSubRecord(c);
        obj.addSubRecord(e);
        return obj;
    }

    private EscherContainerRecord createSpContainer(HSSFTextbox hssfShape, int shapeId) {
        HSSFTextbox shape = hssfShape;
        EscherContainerRecord spContainer = new EscherContainerRecord();
        EscherSpRecord sp = new EscherSpRecord();
        EscherOptRecord opt = new EscherOptRecord();
        EscherRecord anchor = new EscherClientAnchorRecord();
        EscherClientDataRecord clientData = new EscherClientDataRecord();
        this.escherTextbox = new EscherTextboxRecord();
        spContainer.setRecordId((short)-4092);
        spContainer.setOptions((short)15);
        sp.setRecordId((short)-4086);
        sp.setOptions((short)3234);
        sp.setShapeId(shapeId);
        sp.setFlags(2560);
        opt.setRecordId((short)-4085);
        opt.addEscherProperty(new EscherSimpleProperty(128, 0));
        opt.addEscherProperty(new EscherSimpleProperty(129, shape.getMarginLeft()));
        opt.addEscherProperty(new EscherSimpleProperty(131, shape.getMarginRight()));
        opt.addEscherProperty(new EscherSimpleProperty(132, shape.getMarginBottom()));
        opt.addEscherProperty(new EscherSimpleProperty(130, shape.getMarginTop()));
        this.addStandardOptions(shape, opt);
        HSSFAnchor userAnchor = shape.getAnchor();
        anchor = this.createAnchor(userAnchor);
        clientData.setRecordId((short)-4079);
        clientData.setOptions((short)0);
        this.escherTextbox.setRecordId((short)-4083);
        this.escherTextbox.setOptions((short)0);
        spContainer.addChildRecord(sp);
        spContainer.addChildRecord(opt);
        spContainer.addChildRecord(anchor);
        spContainer.addChildRecord(clientData);
        spContainer.addChildRecord(this.escherTextbox);
        return spContainer;
    }

    private TextObjectRecord createTextObjectRecord(HSSFTextbox hssfShape, int shapeId) {
        HSSFTextbox shape = hssfShape;
        TextObjectRecord obj = new TextObjectRecord();
        obj.setHorizontalTextAlignment((short)1);
        obj.setVerticalTextAlignment((short)1);
        obj.setTextLocked(true);
        obj.setTextOrientation((short)0);
        int frLength = (shape.getString().numFormattingRuns() + 1) * 8;
        obj.setFormattingRunLength((short)frLength);
        obj.setTextLength((short)shape.getString().length());
        obj.setStr(shape.getString());
        obj.setReserved7(0);
        return obj;
    }

    public EscherRecord getEscherTextbox() {
        return this.escherTextbox;
    }

    public ObjRecord getObjRecord() {
        return this.objRecord;
    }

    public EscherContainerRecord getSpContainer() {
        return this.spContainer;
    }

    public TextObjectRecord getTextObjectRecord() {
        return this.textObjectRecord;
    }
}

