/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import org.apache.poi.hpsf.HPSFException;
import org.apache.poi.util.LittleEndian;

public class Thumbnail {
    public static int CFTAG_FMTID;
    public static int CFTAG_MACINTOSH;
    public static int CFTAG_NODATA;
    public static int CFTAG_WINDOWS;
    public static int CF_BITMAP;
    public static int CF_DIB;
    public static int CF_ENHMETAFILE;
    public static int CF_METAFILEPICT;
    public static int OFFSET_CF;
    public static int OFFSET_CFTAG;
    public static int OFFSET_WMFDATA;
    private byte[] thumbnailData = null;

    static {
        OFFSET_CFTAG = 4;
        OFFSET_CF = 8;
        OFFSET_WMFDATA = 20;
        CFTAG_WINDOWS = -1;
        CFTAG_MACINTOSH = -2;
        CFTAG_FMTID = -3;
        CFTAG_NODATA = 0;
        CF_METAFILEPICT = 3;
        CF_DIB = 8;
        CF_ENHMETAFILE = 14;
        CF_BITMAP = 2;
    }

    public Thumbnail(byte[] thumbnailData) {
        this.thumbnailData = thumbnailData;
    }

    public Thumbnail() {
    }

    public long getClipboardFormat() throws HPSFException {
        if (this.getClipboardFormatTag() != (long)CFTAG_WINDOWS) {
            throw new HPSFException("Clipboard Format Tag of Thumbnail must be CFTAG_WINDOWS.");
        }
        return LittleEndian.getUInt(this.getThumbnail(), OFFSET_CF);
    }

    public long getClipboardFormatTag() {
        long clipboardFormatTag = LittleEndian.getUInt(this.getThumbnail(), OFFSET_CFTAG);
        return clipboardFormatTag;
    }

    public byte[] getThumbnail() {
        return this.thumbnailData;
    }

    public byte[] getThumbnailAsWMF() throws HPSFException {
        if (this.getClipboardFormatTag() != (long)CFTAG_WINDOWS) {
            throw new HPSFException("Clipboard Format Tag of Thumbnail must be CFTAG_WINDOWS.");
        }
        if (this.getClipboardFormat() != (long)CF_METAFILEPICT) {
            throw new HPSFException("Clipboard Format of Thumbnail must be CF_METAFILEPICT.");
        }
        byte[] thumbnail = this.getThumbnail();
        int wmfImageLength = thumbnail.length - OFFSET_WMFDATA;
        byte[] wmfImage = new byte[wmfImageLength];
        System.arraycopy(thumbnail, OFFSET_WMFDATA, wmfImage, 0, wmfImageLength);
        return wmfImage;
    }

    public void setThumbnail(byte[] thumbnail) {
        this.thumbnailData = thumbnail;
    }
}

