/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ddf;

import org.apache.poi.ddf.EscherProperties;

public abstract class EscherProperty {
    private short id;

    public EscherProperty(short propertyNumber, boolean isComplex, boolean isBlipId) {
        this.id = (short)(propertyNumber + (isComplex ? 32768 : 0) + (isBlipId ? 16384 : 0));
    }

    public EscherProperty(short id) {
        this.id = id;
    }

    public short getId() {
        return this.id;
    }

    public String getName() {
        return EscherProperties.getPropertyName(this.id);
    }

    public short getPropertyNumber() {
        return (short)(this.id & 0x3FFF);
    }

    public int getPropertySize() {
        return 6;
    }

    public boolean isBlipId() {
        return (this.id & 0x4000) != 0;
    }

    public boolean isComplex() {
        return (this.id & Short.MIN_VALUE) != 0;
    }

    public abstract int serializeComplexPart(byte[] var1, int var2);

    public abstract int serializeSimplePart(byte[] var1, int var2);
}

