/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ddf;

import java.io.ByteArrayOutputStream;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.ddf.EscherSerializationListener;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class EscherClientDataRecord
extends EscherRecord {
    public static final String RECORD_DESCRIPTION = "MsofbtClientData";
    public static final short RECORD_ID = -4079;
    private byte[] remainingData;

    public int fillFields(byte[] data, int offset, EscherRecordFactory recordFactory) {
        int bytesRemaining = this.readHeader(data, offset);
        int pos = offset + 8;
        this.remainingData = new byte[bytesRemaining];
        System.arraycopy(data, pos, this.remainingData, 0, bytesRemaining);
        return 8 + bytesRemaining;
    }

    public short getRecordId() {
        return -4079;
    }

    public String getRecordName() {
        return "ClientData";
    }

    public int getRecordSize() {
        return 8 + (this.remainingData == null ? 0 : this.remainingData.length);
    }

    public byte[] getRemainingData() {
        return this.remainingData;
    }

    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        listener.beforeRecordSerialize(offset, this.getRecordId(), this);
        if (this.remainingData == null) {
            this.remainingData = new byte[0];
        }
        LittleEndian.putShort(data, offset, this.getOptions());
        LittleEndian.putShort(data, offset + 2, this.getRecordId());
        LittleEndian.putInt(data, offset + 4, this.remainingData.length);
        System.arraycopy(this.remainingData, 0, data, offset + 8, this.remainingData.length);
        int pos = offset + 8 + this.remainingData.length;
        listener.afterRecordSerialize(pos, this.getRecordId(), pos - offset, this);
        return pos - offset;
    }

    public void setRemainingData(byte[] remainingData) {
        this.remainingData = remainingData;
    }

    public String toString() {
        String extraData;
        String nl = System.getProperty("line.separator");
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            HexDump.dump(this.remainingData, 0L, b, 0);
            extraData = b.toString();
        }
        catch (Exception e) {
            extraData = "error";
        }
        return this.getClass().getName() + ":" + nl + "  RecordId: 0x" + HexDump.toHex((short)-4079) + nl + "  Options: 0x" + HexDump.toHex(this.getOptions()) + nl + "  Extra Data:" + nl + extraData;
    }
}

