/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core.dbsupport;

import java.util.HashSet;
import java.util.Set;
import org.unitils.core.dbsupport.DbSupport;
import org.unitils.core.dbsupport.SQLHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgreSqlDbSupport
extends DbSupport {
    public PostgreSqlDbSupport() {
        super("postgresql");
    }

    @Override
    public Set<String> getTableNames() {
        return this.getSQLHandler().getItemsAsStringSet("select table_name from information_schema.tables where table_type = 'BASE TABLE' and table_schema = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getColumnNames(String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select column_name from information_schema.columns where table_name = '" + tableName + "' and table_schema = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getViewNames() {
        return this.getSQLHandler().getItemsAsStringSet("select table_name from information_schema.tables where table_type = 'VIEW' and table_schema = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getSequenceNames() {
        return this.getSQLHandler().getItemsAsStringSet("select c.relname from pg_class c join pg_namespace n on (c.relnamespace = n.oid) where c.relkind = 'S' and n.nspname = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getTriggerNames() {
        HashSet<String> result = new HashSet<String>();
        Set<String> triggerAndTableNames = this.getSQLHandler().getItemsAsStringSet("select trigger_name || ',' || event_object_table from information_schema.triggers where trigger_schema = '" + this.getSchemaName() + "'");
        for (String triggerAndTableName : triggerAndTableNames) {
            String[] parts = triggerAndTableName.split(",");
            String triggerName = this.quoted(parts[0]);
            String tableName = this.qualified(parts[1]);
            result.add(triggerName + " ON " + tableName);
        }
        return result;
    }

    @Override
    public void dropSequence(String sequenceName) {
        this.getSQLHandler().executeUpdate("drop sequence " + this.qualified(sequenceName) + " cascade");
    }

    @Override
    public void dropTrigger(String triggerName) {
        this.getSQLHandler().executeUpdate("drop trigger " + triggerName + " cascade");
    }

    @Override
    public Set<String> getTypeNames() {
        return this.getSQLHandler().getItemsAsStringSet("select object_name from information_schema.data_type_privileges where object_type = 'USER-DEFINED TYPE' and object_schema = '" + this.getSchemaName() + "'");
    }

    @Override
    public void disableReferentialConstraints() {
        Set<String> tableNames = this.getTableNames();
        for (String tableName : tableNames) {
            this.disableReferentialConstraints(tableName);
        }
    }

    protected void disableReferentialConstraints(String tableName) {
        SQLHandler sqlHandler = this.getSQLHandler();
        Set<String> constraintNames = sqlHandler.getItemsAsStringSet("select constraint_name from information_schema.table_constraints con where con.table_name = '" + tableName + "' and constraint_type = 'FOREIGN KEY' and constraint_schema = '" + this.getSchemaName() + "'");
        for (String constraintName : constraintNames) {
            sqlHandler.executeUpdate("alter table " + this.qualified(tableName) + " drop constraint " + this.quoted(constraintName));
        }
    }

    @Override
    public void disableValueConstraints() {
        Set<String> tableNames = this.getTableNames();
        for (String tableName : tableNames) {
            this.disableValueConstraints(tableName);
        }
    }

    protected void disableValueConstraints(String tableName) {
        SQLHandler sqlHandler = this.getSQLHandler();
        Set<String> constraintNames = sqlHandler.getItemsAsStringSet("select constraint_name from information_schema.table_constraints con, pg_constraint pg_con where pg_con.conname = con.constraint_name and con.table_name = '" + tableName + "' and constraint_type in ('CHECK', 'UNIQUE') and constraint_schema = '" + this.getSchemaName() + "'");
        for (String constraintName : constraintNames) {
            sqlHandler.executeUpdate("alter table " + this.qualified(tableName) + " drop constraint " + this.quoted(constraintName));
        }
        Set<String> primaryKeyColumnNames = sqlHandler.getItemsAsStringSet("select column_name from information_schema.table_constraints con, information_schema.key_column_usage key where con.table_name = '" + tableName + "' and con.table_schema = '" + this.getSchemaName() + "' and key.table_name = con.table_name and key.table_schema = con.table_schema and key.constraint_name = con.constraint_name and con.constraint_type = 'PRIMARY KEY'");
        Set<String> notNullColumnNames = sqlHandler.getItemsAsStringSet("select column_name from information_schema.columns where is_nullable = 'NO' and table_name = '" + tableName + "' and table_schema = '" + this.getSchemaName() + "'");
        for (String notNullColumnName : notNullColumnNames) {
            if (primaryKeyColumnNames.contains(notNullColumnName)) continue;
            sqlHandler.executeUpdate("alter table " + this.qualified(tableName) + " alter column " + notNullColumnName + " drop not null");
        }
    }

    @Override
    public long getSequenceValue(String sequenceName) {
        return this.getSQLHandler().getItemAsLong("select last_value from " + this.qualified(sequenceName));
    }

    @Override
    public void incrementSequenceToValue(String sequenceName, long newSequenceValue) {
        this.getSQLHandler().getItemAsLong("select setval('" + this.qualified(sequenceName) + "', " + newSequenceValue + ")");
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsTriggers() {
        return true;
    }

    @Override
    public boolean supportsTypes() {
        return true;
    }

    @Override
    public boolean supportsCascade() {
        return true;
    }
}

