/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ehcache.annotations;

import com.googlecode.ehcache.annotations.Cacheable;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DecoratedCacheType {
    NONE,
    SELF_POPULATING_CACHE,
    REFRESHING_SELF_POPULATING_CACHE;

    private static final Logger LOGGER;

    public static DecoratedCacheType getDecoratedCacheType(Cacheable ann, Method method) {
        boolean selfPopulating = ann.selfPopulating();
        DecoratedCacheType decoratedCacheType = ann.decoratedCacheType();
        if (selfPopulating) {
            if (decoratedCacheType != NONE) {
                LOGGER.warn("selfPopulating is set to true and decoratedCacheType is set to " + (Object)((Object)decoratedCacheType) + ", selfPopulating will be ignored on: " + method);
            } else {
                return SELF_POPULATING_CACHE;
            }
        }
        return decoratedCacheType;
    }

    static {
        LOGGER = LoggerFactory.getLogger(DecoratedCacheType.class);
    }
}

