/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.json;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.servlet.view.json.JsonWriterConfiguratorTemplate;

public class JsonWriterConfiguratorTemplateRegistry {
    public static final String TEMPLATE_REGISTRY_ATTRIBUTE = JsonWriterConfiguratorTemplateRegistry.class.getName();
    private Map configuratorTemplates = new HashMap();

    private JsonWriterConfiguratorTemplateRegistry() {
    }

    public void registerConfiguratorTemplate(JsonWriterConfiguratorTemplate configuratorTemplate) {
        this.configuratorTemplates.put(configuratorTemplate.getRegistryName(), configuratorTemplate);
    }

    public JsonWriterConfiguratorTemplate findConfiguratorTemplate(String templateName) {
        return (JsonWriterConfiguratorTemplate)this.configuratorTemplates.get(templateName);
    }

    public static JsonWriterConfiguratorTemplateRegistry load(HttpServletRequest request) {
        JsonWriterConfiguratorTemplateRegistry registry = (JsonWriterConfiguratorTemplateRegistry)request.getAttribute(TEMPLATE_REGISTRY_ATTRIBUTE);
        if (registry == null) {
            registry = new JsonWriterConfiguratorTemplateRegistry();
            request.setAttribute(TEMPLATE_REGISTRY_ATTRIBUTE, (Object)registry);
        }
        return registry;
    }
}

