/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core;

import java.util.ArrayList;
import java.util.List;
import net.sf.sojo.core.Conversion;

public final class ConversionHandler {
    private final List<Conversion> conversions = new ArrayList<Conversion>();

    public void addConversion(Conversion pvConversion) {
        if (pvConversion == null) {
            throw new IllegalArgumentException("The Conversion must be different from null");
        }
        if (!this.containsConversion(pvConversion)) {
            this.conversions.add(pvConversion);
        }
    }

    public Conversion replaceConversion(Conversion pvConversion) {
        return this.replaceConversion(pvConversion, false);
    }

    public Conversion replaceAllConversion(Conversion pvConversion) {
        return this.replaceConversion(pvConversion, true);
    }

    protected Conversion replaceConversion(Conversion pvConversion, boolean pvReplaceAll) {
        Conversion lvConversion = null;
        for (int i = 0; i < this.conversions.size(); ++i) {
            lvConversion = this.conversions.get(i);
            if (!lvConversion.getClass().equals(pvConversion.getClass())) continue;
            this.conversions.set(i, pvConversion);
            if (!pvReplaceAll) break;
        }
        return lvConversion;
    }

    public Conversion getConversion(Object pvObject, Class<?> pvToType) {
        for (Conversion lvConversion : this.conversions) {
            if (!(pvToType == null ? lvConversion.isAssignableFrom(pvObject) : lvConversion.isAssignableTo(pvToType) && lvConversion.isAssignableFrom(pvObject))) continue;
            return lvConversion;
        }
        return null;
    }

    public Conversion getConversionByPosition(int pvPosition) {
        return this.conversions.get(pvPosition);
    }

    public int size() {
        return this.conversions.size();
    }

    public void clear() {
        this.conversions.clear();
    }

    public Conversion removeConversion(Conversion pvConversion) {
        if (this.conversions.remove(pvConversion)) {
            return pvConversion;
        }
        return null;
    }

    public boolean containsConversion(Conversion pvConversion) {
        return this.conversions.contains(pvConversion);
    }
}

