/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.TextStyle;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.InternalTextStyle;
import com.supermap.realspace.Theme3D;
import com.supermap.realspace.ThemeLabel3DNative;

public class Theme3DLabel
extends Theme3D {
    TextStyle m_uniformStyle;

    public Theme3DLabel() {
        long l = ThemeLabel3DNative.jni_New();
        this.setHandle(l, true);
    }

    public Theme3DLabel(Theme3DLabel theme3DLabel) {
        if (theme3DLabel == null) {
            String string = InternalResource.loadString("themeLabel3D", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (theme3DLabel.getHandle() == 0L) {
            String string = InternalResource.loadString("themeLabel3D", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ThemeLabel3DNative.jni_Clone(theme3DLabel.getHandle());
        this.setHandle(l, true);
    }

    Theme3DLabel(long l, boolean bl) {
        this.setHandle(l, bl);
    }

    public String getLabelExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLabelExpression()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabel3DNative.jni_GetLabelExpression(this.getHandle());
    }

    public void setLabelExpression(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setLabelExpression(String value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        ThemeLabel3DNative.jni_SetLabelExpression(this.getHandle(), string);
    }

    public TextStyle getUniformStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getUniformStyle()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_uniformStyle == null && (l = ThemeLabel3DNative.jni_GetUniformStyle(this.getHandle())) != 0L) {
            this.m_uniformStyle = InternalTextStyle.createInstance(l);
        }
        return this.m_uniformStyle;
    }

    public void setUniformStyle(TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUniformStyle(TextStyle style)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (textStyle == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle.clone());
        ThemeLabel3DNative.jni_SetUniformStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle);
    }

    public int getNumericPrecision() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getNumericPrecision()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        String string = ThemeLabel3DNative.jni_GetNumericPrecision(this.getHandle());
        if (string.equals("")) {
            return -1;
        }
        int n = string.indexOf(".") + 1;
        string = string.substring(n, string.indexOf("f"));
        return Integer.parseInt(string);
    }

    public void setNumericPrecision(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setNumericPrecision(int value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        String string = "";
        if (n >= 0) {
            string = "0." + n + "f";
        }
        ThemeLabel3DNative.jni_SetNumericPrecision(this.getHandle(), string);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ThemeLabel3DNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{LabelExpression=");
        stringBuffer.append(this.getLabelExpression());
        stringBuffer.append(",UniformStyle=");
        stringBuffer.append(this.getUniformStyle());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    protected void clearHandle() {
        if (this.m_uniformStyle != null) {
            InternalTextStyle.clearHandle(this.m_uniformStyle);
        }
        this.setHandle(0L);
    }
}

