/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolGroupNative;
import com.supermap.data.SymbolGroups;
import com.supermap.data.SymbolLibrary;
import java.util.ArrayList;

public class SymbolGroup
extends InternalHandleDisposable {
    private SymbolLibrary _$6;
    private SymbolGroup _$5;
    private SymbolGroups _$4;
    private ArrayList _$3;

    SymbolGroup(SymbolLibrary symbolLibrary, long l) {
        this._$6 = symbolLibrary;
        this.setHandle(l, false);
        this._$3 = new ArrayList();
        this.reset();
        InternalHandleDisposable.makeSureNativeObjectLive(symbolLibrary);
    }

    SymbolGroup(long l, SymbolGroup symbolGroup) {
        this._$6 = symbolGroup.getLib();
        this.setHandle(l, false);
        this.setParent(symbolGroup);
        this._$3 = new ArrayList();
        this.reset();
        InternalHandleDisposable.makeSureNativeObjectLive(symbolGroup);
    }

    public SymbolGroup getParent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getParent()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$5;
    }

    public SymbolGroups getChildGroups() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getChildGroups()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4 == null) {
            this._$4 = new SymbolGroups(this);
        }
        return this._$4;
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolGroupNative.jni_GetName(this.getHandle());
    }

    public void setName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setName(String name)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("name", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (this.getParent() != null && this.getParent().getChildGroups().contains(string)) {
            String string4 = InternalResource.loadString("value", "Global_SpecifiedNameAlreadyExist", "data_resources");
            throw new IllegalStateException(string4);
        }
        SymbolGroupNative.jni_SetName(this.getHandle(), string);
    }

    public Symbol get(int n) {
        Symbol symbol = null;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n >= 0 && n < this._$3.size()) {
            symbol = (Symbol)this._$3.get(n);
        }
        return symbol;
    }

    public SymbolLibrary getLibrary() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLibrary()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$6;
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolGroupNative.jni_GetCount(this.getHandle());
    }

    public int indexOf(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolGroupNative.jni_IndexOf(this.getHandle(), n);
    }

    protected boolean moveTo(int n, SymbolGroup symbolGroup) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveTo(int index, SymbolGroup group)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (symbolGroup == null) {
            String string = InternalResource.loadString("group", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(symbolGroup);
        if (l == 0L) {
            String string = InternalResource.loadString("group", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = SymbolGroupNative.jni_moveTo(this.getHandle(), n, l);
        if (bl) {
            symbolGroup.getSymbols().add(this.get(n));
            this.get(n).setGroup(symbolGroup);
            this.getSymbols().remove(n);
        }
        symbolGroup.makeSureNativeObjectLive();
        return bl;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
    }

    protected void clearHandle() {
        this._$6 = null;
        this._$6 = null;
        this._$5 = null;
        if (this._$4 != null) {
            this._$4.clearHandle();
            this._$4 = null;
        }
        if (this._$3 != null) {
            for (int i = 0; i < this._$3.size(); ++i) {
                ((Symbol)this._$3.get(i)).clearHandle();
            }
            this._$3.clear();
            this._$3 = null;
        }
        this.setHandle(0L);
    }

    void setParent(SymbolGroup symbolGroup) {
        this._$5 = symbolGroup;
    }

    void reset() {
        int n;
        for (n = 0; n < this._$3.size(); ++n) {
            ((Symbol)this._$3.get(n)).clearHandle();
        }
        this._$3.clear();
        n = this.getCount();
        if (n > 0) {
            long[] lArray = new long[n];
            SymbolGroupNative.jni_GetSymbols(this.getHandle(), lArray);
            for (int i = 0; i < n; ++i) {
                Symbol symbol = Symbol.createInstance(lArray[i]);
                if (symbol == null) continue;
                symbol.setIsDisposable(false);
                symbol.setLibrary(this._$6);
                symbol.setGroup(this);
                this._$3.add(symbol);
            }
        }
        if (this._$4 != null) {
            this._$4.reset();
        }
    }

    ArrayList getSymbols() {
        return this._$3;
    }

    SymbolLibrary getLib() {
        return this._$6;
    }

    boolean remove(int n) {
        int n2 = this.indexOf(n);
        if (n2 != -1) {
            this.getSymbols().remove(n2);
            return SymbolGroupNative.jni_RemoveByID(this.getHandle(), n);
        }
        int n3 = 0;
        if (n3 < this._$4.getCount()) {
            return this._$4.get(n3).remove(n);
        }
        return false;
    }

    SymbolGroup findGroup(int n) {
        SymbolGroup symbolGroup = null;
        if (this.indexOf(n) != -1) {
            return this;
        }
        for (int i = 0; i < this.getChildGroups().getCount(); ++i) {
            symbolGroup = this.getChildGroups().get(i).findGroup(n);
            if (symbolGroup == null) continue;
            return symbolGroup;
        }
        return symbolGroup;
    }

    Symbol findSymbol(int n) {
        int n2;
        Symbol symbol = null;
        for (n2 = 0; n2 < this.getCount(); ++n2) {
            symbol = this.get(n2);
            if (symbol == null || symbol.getID() != n) continue;
            return symbol;
        }
        for (n2 = 0; n2 < this.getChildGroups().getCount(); ++n2) {
            symbol = this.getChildGroups().get(n2).findSymbol(n);
            if (symbol == null) continue;
            return symbol;
        }
        return null;
    }

    Symbol findSymbol(String string) {
        int n;
        Symbol symbol = null;
        for (n = 0; n < this.getCount(); ++n) {
            symbol = this.get(n);
            if (symbol == null || !symbol.getName().equals(string)) continue;
            return symbol;
        }
        for (n = 0; n < this.getChildGroups().getCount(); ++n) {
            symbol = this.getChildGroups().get(n).findSymbol(string);
            if (symbol == null) continue;
            return symbol;
        }
        return null;
    }
}

