/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Domain;
import com.supermap.data.FieldType;
import com.supermap.data.InternalResource;
import com.supermap.data.RangeDomainNative;
import com.supermap.data.RangeInfo;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeDomain
extends Domain {
    RangeDomain(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l);
    }

    protected RangeDomain() {
        this.setHandle(RangeDomainNative.jni_New());
    }

    public RangeDomain(int n, String string, String string2, FieldType fieldType) {
        long l = RangeDomainNative.jni_New3(n, string, string2, fieldType.value());
        if (l == 0L) {
            String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        this.setHandle(l);
    }

    public RangeDomain(int n, String string, String string2, FieldType fieldType, ArrayList<RangeInfo> arrayList) {
        long[] lArray = new long[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i).getHandle() == 0L) {
                String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string3);
            }
            lArray[i] = arrayList.get(i).getHandle();
        }
        long l = RangeDomainNative.jni_New2(n, string, string2, fieldType.value(), lArray);
        if (l == 0L) {
            String string4 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string4);
        }
        this.setHandle(l);
    }

    public int getRangeCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getRangeInfos().length;
    }

    public RangeInfo[] getRangeInfos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = RangeDomainNative.jni_GetRangeInfos(this.getHandle());
        RangeInfo[] rangeInfoArray = new RangeInfo[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            rangeInfoArray[i] = new RangeInfo(lArray[i]);
        }
        return rangeInfoArray;
    }

    public RangeInfo get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getRangeCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        long l = RangeDomainNative.jni_Get(this.getHandle(), n);
        RangeInfo rangeInfo = new RangeInfo(l);
        return rangeInfo;
    }

    public boolean add(RangeInfo rangeInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (null == rangeInfo) {
            return false;
        }
        if (rangeInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return RangeDomainNative.jni_Add(this.getHandle(), rangeInfo.getHandle());
    }

    public void append(RangeInfo[] rangeInfoArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (null == rangeInfoArray) {
            return;
        }
        long[] lArray = new long[rangeInfoArray.length];
        for (int i = 0; i < rangeInfoArray.length; ++i) {
            if (rangeInfoArray[i].getHandle() == 0L) {
                String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = rangeInfoArray[i].getHandle();
        }
        RangeDomainNative.jni_Append(this.getHandle(), lArray);
    }

    public boolean set(int n, RangeInfo rangeInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (null == rangeInfo) {
            return false;
        }
        if (n < 0 || n >= this.getRangeCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (rangeInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return RangeDomainNative.jni_Set(this.getHandle(), n, rangeInfo.getHandle());
    }

    public void remove(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getRangeCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        RangeDomainNative.jni_Remove(this.getHandle(), n);
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        RangeDomainNative.jni_RemoveAll(this.getHandle());
    }
}

