/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLine;
import com.supermap.data.GeoRectangle;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoRoundRectangleNative;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;

public class GeoRoundRectangle
extends Geometry {
    public GeoRoundRectangle() {
        long l = GeoRoundRectangleNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoRoundRectangle(GeoRoundRectangle geoRoundRectangle) {
        if (geoRoundRectangle == null) {
            String string = InternalResource.loadString("GeoRoundRectangle geoRoundRectangle", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoRoundRectangle);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoRoundRectangle geoRoundRectangle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l2 = GeoRoundRectangleNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoRoundRectangle);
    }

    public GeoRoundRectangle(Point2D point2D, double d, double d2, double d3, double d4, double d5) {
        if (d < 0.0) {
            String string = InternalResource.loadString("width", "GeoRoundRectangle_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = InternalResource.loadString("height", "GeoRoundRectangle_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d3 < 0.0) {
            String string = InternalResource.loadString("radiusX", "GeoRoundRectangle_RadiusXShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d4 < 0.0) {
            String string = InternalResource.loadString("radiusY", "GeoRoundRectangle_RadiusYShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d < 2.0 * d3) {
            String string = InternalResource.loadString("width <2*radiusX", "GeoRoundRectangle_WidthShouldNotLessThan2RadiusX", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 < 2.0 * d4) {
            String string = InternalResource.loadString("height < 2*radiusY", "GeoRoundRectangle_HeightShouldNotLessThan2RadiusY", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoRoundRectangleNative.jni_New1(point2D.getX(), point2D.getY(), d, d2, d5, d3, d4);
        this.setHandle(l, true);
    }

    public GeoRoundRectangle(Rectangle2D rectangle2D, double d, double d2, double d3) {
        if (d < 0.0) {
            String string = InternalResource.loadString("radiusX", "GeoRoundRectangle_RadiusXShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = InternalResource.loadString("radiusY", "GeoRoundRectangle_RadiusYShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D.getWidth() < 0.0) {
            String string = InternalResource.loadString("rectangle width", "GeoRectangleWidthShouldPositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D.getHeight() < 0.0) {
            String string = InternalResource.loadString("rectangle height", "GeoRectangleWidthShouldPositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D.getWidth() < 2.0 * d) {
            String string = InternalResource.loadString("width <2*radiusX", "GeoRoundRectangle_WidthShouldNotLessThan2RadiusX", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D.getHeight() < 2.0 * d2) {
            String string = InternalResource.loadString("height < 2*radiusY", "GeoRoundRectangle_HeightShouldNotLessThan2RadiusY", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoRoundRectangleNative.jni_New2(rectangle2D.getLeft(), rectangle2D.getRight(), rectangle2D.getTop(), rectangle2D.getBottom(), d3, d, d2);
        this.setHandle(l, true);
    }

    public GeoRoundRectangle(GeoRectangle geoRectangle, double d, double d2) {
        if (d < 0.0) {
            String string = InternalResource.loadString("radiusX", "GeoRoundRectangle_RadiusXShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = InternalResource.loadString("radiusY", "GeoRoundRectangle_RadiusYShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoRectangle.getWidth() < 2.0 * d) {
            String string = InternalResource.loadString("width <2*radiusX", "GeoRoundRectangle_WidthShouldNotLessThan2RadiusX", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoRectangle.getHeight() < 2.0 * d2) {
            String string = InternalResource.loadString("height < 2*radiusY", "GeoRoundRectangle_HeightShouldNotLessThan2RadiusY", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoRectangle == null) {
            String string = InternalResource.loadString("geoRectangle", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoRectangle);
        if (l == 0L) {
            String string = InternalResource.loadString("geoRectangle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoRoundRectangleNative.jni_New3(l, d, d2);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoRectangle);
    }

    GeoRoundRectangle(long l) {
        this.setHandle(l, false);
    }

    public Point2D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoRoundRectangleNative.jni_getCenter(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public void setCenter(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetCenter(Point2D point2D)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoRoundRectangleNative.jni_setCenter(this.getHandle(), point2D.getX(), point2D.getY());
    }

    public double getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRoundRectangleNative.jni_getWidth(this.getHandle());
    }

    public void setWidth(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetWidth(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "GeoRoundRectangle_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d < 2.0 * this.getRadiusX()) {
            String string = InternalResource.loadString("value <2*radiusX", "GeoRoundRectangle_WidthShouldNotLessThan2RadiusX", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoRoundRectangleNative.jni_setWidth(this.getHandle(), d);
    }

    public double getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRoundRectangleNative.jni_getHeight(this.getHandle());
    }

    public void setHeight(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetHeight(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "GeoRoundRectangle_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d < 2.0 * this.getRadiusY()) {
            String string = InternalResource.loadString("height < 2*radiusY", "GeoRoundRectangle_HeightShouldNotLessThan2RadiusY", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoRoundRectangleNative.jni_setHeight(this.getHandle(), d);
    }

    public double getRadiusX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetRadiusX()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRoundRectangleNative.jni_getRadiusX(this.getHandle());
    }

    public void setRadiusX(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetRadiusX(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "GeoRoundRectangle_RadiusXShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getWidth() < 2.0 * d) {
            String string = InternalResource.loadString("value <2*radiusX", "GeoRoundRectangle_WidthShouldNotLessThan2RadiusX", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoRoundRectangleNative.jni_setRadiusX(this.getHandle(), d);
    }

    public double getRadiusY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetRadiusY()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRoundRectangleNative.jni_getRadiusY(this.getHandle());
    }

    public void setRadiusY(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetRadiusY(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "GeoRoundRectangle_RadiusYShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHeight() < 2.0 * d) {
            String string = InternalResource.loadString("height < 2*radiusY", "GeoRoundRectangle_HeightShouldNotLessThan2RadiusY", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoRoundRectangleNative.jni_setRadiusY(this.getHandle(), d);
    }

    public double getRotation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRoundRectangleNative.jni_getAngle(this.getHandle());
    }

    public void setRotation(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRotation(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoRoundRectangleNative.jni_setAngle(this.getHandle(), d);
    }

    public double getPerimeter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetPerimeter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRoundRectangleNative.jni_getPerimeter(this.getHandle());
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRoundRectangleNative.jni_getArea(this.getHandle());
    }

    public GeoLine convertToLine(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ConvertToLine(int segmentCountOfRoundConner)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 2) {
            String string = InternalResource.loadString("ConvertToLine(int segmentCountOfRoundConner)", "GeoRoundRectangle_GeoLineSegmentCountShouldGreaterThanOne", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoRoundRectangleNative.jni_convertToLine(this.getHandle(), n);
        GeoLine geoLine = null;
        if (l != 0L) {
            geoLine = new GeoLine(l);
            geoLine.setHandle(l, true);
        }
        return geoLine;
    }

    public GeoRegion convertToRegion(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ConvertToRegion(int segmentCountOfRoundConner)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 2) {
            String string = InternalResource.loadString("convertToRegion(int segmentCountOfRoundConner)", "GeoRoundRectangle_GeoRegionSegmentCountShouldGreaterThanOne", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoRoundRectangleNative.jni_convertToRegion(this.getHandle(), n);
        GeoRegion geoRegion = null;
        if (l != 0L) {
            geoRegion = new GeoRegion(l);
            geoRegion.setHandle(l, true);
        }
        return geoRegion;
    }

    public GeoRoundRectangle clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoRoundRectangle(this);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoRoundRectangleNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }
}

