/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoPicture3DNative;
import com.supermap.data.GeoPictureNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;
import java.io.File;

public class GeoPicture3D
extends Geometry3D {
    public GeoPicture3D() {
        long l = GeoPicture3DNative.jni_New();
        this.setHandle(l, true);
    }

    GeoPicture3D(long l) {
        this.setHandle(l, false);
    }

    public GeoPicture3D(GeoPicture3D geoPicture3D) {
        if (geoPicture3D == null) {
            String string = InternalResource.loadString("geoPicture3D", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoPicture3D);
        if (l == 0L) {
            String string = InternalResource.loadString("geoPicture3D", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoPictureNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoPicture3D);
    }

    public GeoPicture3D(String string, Point3D point3D, double d, double d2, double d3) {
        File file = new File(string);
        if (!file.exists()) {
            String string2 = InternalResource.loadString("imageFile", "Global_FileNotExists", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (d <= 0.0) {
            String string3 = InternalResource.loadString("width", "GeoPicture3D_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (d2 <= 0.0) {
            String string4 = InternalResource.loadString("height", "GeoPicture3D_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        long l = GeoPicture3DNative.jni_New1(string, point3D.getX(), point3D.getY(), point3D.getZ(), d, d2, d3);
        if (l == 0L) {
            String string5 = InternalResource.loadString("GeoPicture3D(String imageFile, Point3D position, double width,double height, double rotationZ)", "GeoPicture_FailConstruct", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        this.setHandle(l, true);
    }

    public double getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPicture3DNative.jni_getWidth(this.getHandle());
    }

    public void setWidth(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWidth(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "GeoPicture3D_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoPicture3DNative.jni_setWidth(this.getHandle(), d);
    }

    public double getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPicture3DNative.jni_getHeight(this.getHandle());
    }

    public void setHeight(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHeight(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "GeoPicture3D_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoPicture3DNative.jni_setHeight(this.getHandle(), d);
    }

    public String getImageFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageFile()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPicture3DNative.jni_getImageFile(this.getHandle());
    }

    public void setImageFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setImageFile(String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        GeoPicture3DNative.jni_setImageFile(this.getHandle(), string);
    }

    public GeoPicture3D clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoPicture3D(this);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoPicture3DNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }
}

