/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.conversation.impl;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import org.springframework.webflow.conversation.ConversationLockException;
import org.springframework.webflow.conversation.impl.ConversationLock;
import org.springframework.webflow.conversation.impl.LockInterruptedException;
import org.springframework.webflow.conversation.impl.LockTimeoutException;

class JdkBackportConcurrentConversationLock
implements ConversationLock {
    private Lock lock = new ReentrantLock();
    private int timeoutSeconds;

    public JdkBackportConcurrentConversationLock(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public void lock() throws ConversationLockException {
        try {
            boolean acquired = this.lock.tryLock((long)this.timeoutSeconds, TimeUnit.SECONDS);
            if (!acquired) {
                throw new LockTimeoutException(this.timeoutSeconds);
            }
        }
        catch (InterruptedException e) {
            throw new LockInterruptedException(e);
        }
    }

    public void unlock() {
        this.lock.unlock();
    }
}

