/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.interchange.csv;

import java.util.ArrayList;
import java.util.List;
import net.sf.sojo.interchange.csv.CsvParserException;
import net.sf.sojo.util.Table;

public class CsvParser {
    public static final char COMMA = ',';
    public static final char SPACE = ' ';
    public static final char DQUOTE = '\"';
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final String CRLF = "\r\n";
    private int charPointer = 0;
    private char seperator = (char)44;
    private Table table = null;
    private boolean withLineFeed = true;

    public char getSeperator() {
        return this.seperator;
    }

    public void setSeperator(char pvSeperator) {
        this.seperator = pvSeperator;
    }

    public void setWithLineFeed(boolean pvWithLineFeed) {
        this.withLineFeed = pvWithLineFeed;
    }

    public boolean getWithLineFeed() {
        return this.withLineFeed;
    }

    private char getNextCahr(char[] pvChars, char pvElse) {
        if (pvChars.length > this.charPointer + 1) {
            return pvChars[this.charPointer + 1];
        }
        return pvElse;
    }

    private void escaped(char[] pvChars) {
        char c;
        StringBuffer sb = new StringBuffer();
        int charLength = pvChars.length;
        boolean cancle = false;
        while (!cancle) {
            if (this.charPointer < charLength) {
                c = pvChars[this.charPointer];
                if ('\"' == c) {
                    char nextChar = this.getNextCahr(pvChars, ' ');
                    if ('\"' == nextChar) {
                        sb.append(c);
                        ++this.charPointer;
                    } else {
                        cancle = true;
                    }
                } else {
                    sb.append(c);
                }
                ++this.charPointer;
                continue;
            }
            throw new CsvParserException("Missing closed double quote.");
        }
        this.table.addValue2CurrentRow(sb.toString());
        cancle = false;
        while (!cancle) {
            if (this.charPointer < charLength) {
                c = pvChars[this.charPointer];
                if (this.getSeperator() == c || '\r' == c) {
                    cancle = true;
                    continue;
                }
                ++this.charPointer;
                continue;
            }
            cancle = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean nonEscaped(char[] pvChars) {
        StringBuffer sb = new StringBuffer();
        int charLength = pvChars.length;
        boolean cancel = false;
        boolean lvReturn = false;
        int startCharPointer = this.charPointer + 1;
        boolean lvAddEmptyString = false;
        while (!cancel) {
            if (this.charPointer < charLength) {
                char nextChar;
                char c = pvChars[this.charPointer];
                if (this.getSeperator() == c) {
                    cancel = true;
                    nextChar = this.getNextCahr(pvChars, '\r');
                    if (this.charPointer == charLength - 1 || this.getSeperator() == nextChar || '\r' == nextChar) {
                        lvAddEmptyString = true;
                    }
                } else if ('\r' == c) {
                    if (this.getWithLineFeed()) {
                        nextChar = this.getNextCahr(pvChars, ' ');
                        if ('\n' != nextChar) throw new CsvParserException("Expected LF and not -" + nextChar + "-");
                        cancel = true;
                        lvReturn = true;
                    } else {
                        cancel = true;
                        lvReturn = true;
                    }
                } else {
                    if ('\"' == c) {
                        for (int i = startCharPointer; i < this.charPointer; ++i) {
                            if (' ' == pvChars[i]) continue;
                            throw new CsvParserException("Invalid char: " + pvChars[i] + " on column " + i + " in csv string: " + new String(pvChars));
                        }
                        return false;
                    }
                    sb.append(c);
                }
                ++this.charPointer;
                continue;
            }
            cancel = true;
        }
        this.table.addValue2CurrentRow(sb.toString().trim());
        if (!lvAddEmptyString) return lvReturn;
        this.table.addValue2CurrentRow("");
        return lvReturn;
    }

    public List<?> parseAndGetFirstLine(String pvLineString) {
        Table lvTable = this.parse(pvLineString);
        if (lvTable.getCurrentRowNumber() > 0) {
            return lvTable.getRows().get(0);
        }
        return new ArrayList();
    }

    public Table parse(String pvLineString) {
        this.table = new Table();
        if (pvLineString != null) {
            char[] lvChars = pvLineString.toCharArray();
            int charLength = lvChars.length;
            boolean cancel = false;
            this.charPointer = 0;
            if (charLength > 0) {
                if (this.getSeperator() == lvChars[0]) {
                    this.table.addValue2CurrentRow("");
                }
                while (!cancel) {
                    char nextChar;
                    if (charLength <= this.charPointer) {
                        cancel = true;
                        this.table.newRow();
                        continue;
                    }
                    char c = lvChars[this.charPointer];
                    if (this.getSeperator() == c) {
                        nextChar = this.getNextCahr(lvChars, '\r');
                        if (this.getSeperator() == nextChar || '\r' == nextChar) {
                            this.table.addValue2CurrentRow("");
                        }
                        ++this.charPointer;
                        continue;
                    }
                    if ('\r' == c) {
                        if (charLength == 1) {
                            this.table.addValue2CurrentRow("");
                            ++this.charPointer;
                        }
                        if (this.getWithLineFeed()) {
                            nextChar = this.getNextCahr(lvChars, ' ');
                            if ('\n' != nextChar) continue;
                            ++this.charPointer;
                            this.table.newRow();
                            continue;
                        }
                        ++this.charPointer;
                        this.table.newRow();
                        continue;
                    }
                    if ('\"' == c) {
                        ++this.charPointer;
                        this.escaped(lvChars);
                        continue;
                    }
                    boolean isCrLf = this.nonEscaped(lvChars);
                    if (!isCrLf) continue;
                    this.table.newRow();
                }
            }
        }
        this.table.removeRow(this.table.getCurrentRowNumber() - 1);
        try {
            this.table.validateAndRemoveEmptyRows();
        }
        catch (IllegalStateException e) {
            throw new CsvParserException(e.getMessage());
        }
        return this.table;
    }
}

