/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.geoprocessor.common;

import java.io.File;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogProvider {
    private static LogProvider instance = null;
    private static String logPath = "";

    private LogProvider() {
        File file = new File(logPath);
        try {
            if (file.exists() && file.canRead()) {
                PropertyConfigurator.configure((String)logPath);
            } else {
                PropertyConfigurator.configure((URL)LogProvider.class.getResource("log4j.properties"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static synchronized LogProvider initialize() {
        if (instance == null) {
            instance = new LogProvider();
        }
        return instance;
    }

    public static void setLogPath(String string) {
        if (string == null) {
            logPath = "";
        }
        logPath = string;
    }

    public static String getLogPath() {
        return logPath;
    }

    public static Log getLog(Class<?> clazz) {
        LogProvider.initialize();
        return LogFactory.getLog(clazz);
    }
}

