/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CUDACapability;
import com.supermap.data.Charset;
import com.supermap.data.EngineFamilyType;
import com.supermap.data.EngineInfo;
import com.supermap.data.EngineType;
import com.supermap.data.Enum;
import com.supermap.data.EnvironmentNative;
import com.supermap.data.InternalResource;
import com.supermap.data.ObjectsRuntimeException;
import com.supermap.data.Toolkit;
import java.awt.Canvas;
import java.util.ArrayList;

public class Environment {
    public static final double DEFAULT_MAX_EQUAL_ZERO_PRECISION = 1.0E-10;
    public static final double DEFAULT_MIN_EQUAL_ZERO_PRECISION = -1.0E-10;
    private static double _$3;
    private static double _$2;
    private static boolean _$1;

    protected Environment() {
    }

    public static double getMaxEqualZeroPrecision() {
        return _$3;
    }

    public static void setMaxEqualZeroPrecision(double d) {
        _$3 = d;
    }

    public static double getMinEqualZeroPrecision() {
        return _$2;
    }

    public static void setMinEqualZeroPrecision(double d) {
        _$2 = d;
    }

    public static String getFileCacheFolder() {
        return EnvironmentNative.jni_GetFileCacheFolder();
    }

    public static void setFileCacheFolder(String string) {
        if (string == null) {
            string = "";
        }
        EnvironmentNative.jni_SetFileCacheFolder(string);
    }

    @Deprecated
    public static boolean isCustomMapRatioEnabled() {
        return EnvironmentNative.jni_GetCustomMapRatioEnabled();
    }

    @Deprecated
    public static void setCustomMapRatioEnabled(boolean bl) {
        EnvironmentNative.jni_SetCustomMapRatioEnabled(bl);
    }

    public static void setCustomDPIEnabled(boolean bl) {
        EnvironmentNative.jni_SetCustomDPIEnabled(bl);
    }

    public static boolean isCustomDPIEnabled() {
        return EnvironmentNative.jni_GetCustomDPIEnabled();
    }

    public static double getSystemDPI() {
        return EnvironmentNative.jni_GetSystemDPI();
    }

    public static void setSystemDPI(double d) {
        EnvironmentNative.jni_SetSystemDPI(d);
    }

    @Deprecated
    public static boolean isClearTypeSupported() {
        return false;
    }

    @Deprecated
    public static void setClearTypeSupported(boolean bl) {
    }

    @Deprecated
    public static double getCustomMapRatioX() {
        return EnvironmentNative.jni_GetCustomMapRatioX();
    }

    @Deprecated
    public static void setCustomMapRatioX(double d) {
        EnvironmentNative.jni_SetCustomMapRatioX(d);
    }

    @Deprecated
    public static double getCustomMapRatioY() {
        return EnvironmentNative.jni_GetCustomMapRatioY();
    }

    @Deprecated
    public static void setCustomMapRatioY(double d) {
        EnvironmentNative.jni_SetCustomMapRatioY(d);
    }

    public static double getCustomDPIX() {
        return EnvironmentNative.jni_GetCustomDPIX();
    }

    public static void setCustomDPIX(double d) {
        EnvironmentNative.jni_SetCustomDPIX(d);
    }

    public static double getCustomDPIY() {
        return EnvironmentNative.jni_GetCustomDPIY();
    }

    public static void setCustomDPIY(double d) {
        EnvironmentNative.jni_SetCustomDPIY(d);
    }

    public static boolean isUnicodeVersion() {
        return EnvironmentNative.jni_IsUnicodeVersion();
    }

    public static EngineInfo[] getCurrentLoadedEngineInfos() {
        int n = EnvironmentNative.jni_GetCurrentLoadedEngineCount();
        ArrayList<EngineInfo> arrayList = new ArrayList<EngineInfo>();
        int[] nArray = new int[n];
        EnvironmentNative.jni_GetCurrentLoadedEngine(nArray);
        for (int i = 0; i < n; ++i) {
            EngineType engineType = (EngineType)Enum.parseUGCValue(EngineType.class, nArray[i]);
            String string = EnvironmentNative.jni_GetSupportExtenstions(i);
            String[] stringArray = Toolkit.splitString(string, ";");
            String string2 = EnvironmentNative.jni_GetEngineName(i);
            int n2 = EnvironmentNative.jni_GetEngienFamilyType(i);
            EngineFamilyType engineFamilyType = (EngineFamilyType)Enum.parseUGCValue(EngineFamilyType.class, n2);
            EngineInfo engineInfo = new EngineInfo(engineType, stringArray, string2, engineFamilyType);
            arrayList.add(engineInfo);
        }
        EngineInfo[] engineInfoArray = new EngineInfo[arrayList.size()];
        return arrayList.toArray(engineInfoArray);
    }

    public static EngineType[] getCurrentLoadedEngine() {
        int n;
        Environment.LoadWrapJ();
        int n2 = EnvironmentNative.jni_GetCurrentLoadedEngineCount();
        ArrayList<EngineType> arrayList = new ArrayList<EngineType>();
        int[] nArray = new int[n2];
        EnvironmentNative.jni_GetCurrentLoadedEngine(nArray);
        for (n = 0; n < n2; ++n) {
            arrayList.add((EngineType)Enum.parseUGCValue(EngineType.class, nArray[n]));
        }
        n = arrayList.size();
        EngineType[] engineTypeArray = new EngineType[n];
        for (int i = 0; i < n; ++i) {
            engineTypeArray[i] = (EngineType)arrayList.get(i);
        }
        return engineTypeArray;
    }

    public static Charset getCurrentCharset() {
        int n = EnvironmentNative.jni_GetCurrentCharset();
        return (Charset)Enum.parse(Charset.class, n);
    }

    public static void setCurrentCharset(Charset charset) {
        if (charset == null) {
            String string = InternalResource.loadString("charset", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        EnvironmentNative.jni_SetCurrentCharset(charset.value());
    }

    static void LoadWrapJ() {
        if (!_$1) {
            try {
                new Canvas();
                String string = System.getProperty("os.name").toLowerCase();
                if (string.startsWith("linux")) {
                    System.loadLibrary("SuBase");
                }
                System.loadLibrary("Wrapj");
                EnvironmentNative.jni_InitEnvironment();
                _$1 = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                unsatisfiedLinkError.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected static void InternalLoadWrapJ() {
        Environment.LoadWrapJ();
    }

    public static int getOMPNumThreads() {
        return EnvironmentNative.jni_GetOMPNumThreads();
    }

    public static void setOMPNumThreads(int n) {
        if (n <= 0) {
            String string = InternalResource.loadString("OMPNumThreads", "OMPNumThreads_CannotLessOrEqualsZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n > 16) {
            String string = InternalResource.loadString("OMPNumThreads", "OMPNumThreads_OutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        EnvironmentNative.jni_SetOMPNumThreads(n);
    }

    public static int getSceneAntialiasValue() {
        return EnvironmentNative.jni_GetSceneAntialiasValue();
    }

    public static void setSceneAntialiasValue(int n) {
        EnvironmentNative.jni_SetSceneAntialiasValue(n);
    }

    public static void setSceneAntialias(boolean bl) {
        EnvironmentNative.jni_SetSceneAntialias(bl);
    }

    public static boolean isSceneAntialias() {
        return EnvironmentNative.jni_IsSceneAntialias();
    }

    public static long getAnalystMemorySize() {
        return EnvironmentNative.jni_GetAnalystMemorySize();
    }

    public static void setAnalystMemorySize(long l) {
        boolean bl = EnvironmentNative.jni_SetAnalystMemorySize(l);
        if (!bl) {
            String string = InternalResource.loadString("AnalystMemorySize", "SettingAnalystMemorySizeFailed", "data_resources");
            throw new ObjectsRuntimeException(string);
        }
    }

    public static void setMapInflated(boolean bl) {
        EnvironmentNative.jni_SetMapInflated(bl);
    }

    public static boolean isMapInflated() {
        return EnvironmentNative.jni_IsMapInflated();
    }

    public static String getUGOBasePath() {
        return EnvironmentNative.jni_GetBasePath();
    }

    public static void setCUDAComputingEnabled(boolean bl) {
        EnvironmentNative.jni_SetCUDAComputingEnabled(bl);
    }

    public static boolean isCUDAComputingEnabled() {
        return EnvironmentNative.jni_IsCUDAComputingEnabled();
    }

    public static CUDACapability checkCUDACapability() {
        int n = EnvironmentNative.jni_CheckCUDACapability();
        return (CUDACapability)Enum.parseUGCValue(CUDACapability.class, n);
    }

    static {
        Environment.LoadWrapJ();
        _$3 = 1.0E-10;
        _$2 = -1.0E-10;
        _$1 = false;
    }
}

