/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Colors;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetCollectionChangeOrderEvent;
import com.supermap.data.DatasetCollectionChangeOrderListener;
import com.supermap.data.DatasetCollectionEvent;
import com.supermap.data.DatasetCollectionListener;
import com.supermap.data.DatasetCollectionRemoveAllEvent;
import com.supermap.data.DatasetCollectionRemoveAllListener;
import com.supermap.data.DatasetCollectionRenameEvent;
import com.supermap.data.DatasetCollectionRenameListener;
import com.supermap.data.DatasetCollectionRequireRefreshEvent;
import com.supermap.data.DatasetCollectionRequireRefreshListener;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetGridCollectionNative;
import com.supermap.data.DatasetImageCollectionNative;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.PixelFormat;
import com.supermap.data.Rectangle2D;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetGridCollection
extends Dataset {
    private Vector<DatasetCollectionRenameListener> _$13;
    private Vector<DatasetCollectionRenameListener> _$12;
    private Vector<DatasetCollectionListener> _$11;
    private Vector<DatasetCollectionListener> _$10;
    private Vector<DatasetCollectionListener> _$9;
    private Vector<DatasetCollectionChangeOrderListener> _$8;
    private Vector<DatasetCollectionRemoveAllListener> _$7;
    private Vector<DatasetCollectionRemoveAllListener> _$6;
    private Vector<DatasetCollectionRequireRefreshListener> _$5;
    private GeoRegion _$4 = null;
    private Colors _$3 = null;

    protected DatasetGridCollection() {
        m_senderMethodName = "buildPyramid";
    }

    DatasetGridCollection(long l, Datasource datasource) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("datasource", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l);
        this.m_datasource = datasource;
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridCollectionNative.jni_GetCount(this.getHandle());
    }

    public DatasetGrid getDataset(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("get(String name)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        long l = DatasetGridCollectionNative.jni_GetSubDataset(this.getHandle(), string);
        DatasetGrid datasetGrid = null;
        if (l != 0L) {
            datasetGrid = new DatasetGrid(l, this.m_datasource);
        }
        return datasetGrid;
    }

    public String get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetGridCollectionNative.jni_GetAliasName(this.getHandle(), n);
    }

    private String[] _$2() {
        return DatasetGridCollectionNative.jni_GetAliasNames(this.getHandle());
    }

    protected static String[] getAliasNames(DatasetGridCollection datasetGridCollection) {
        if (datasetGridCollection != null && datasetGridCollection.getHandle() != 0L) {
            return datasetGridCollection._$2();
        }
        return null;
    }

    public int indexOf(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("indexOf(String aliasName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        return DatasetGridCollectionNative.jni_GetSubDatasetOrder(this.getHandle(), string);
    }

    public DatasetVector getAttributeDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAttributeTable()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = DatasetGridCollectionNative.jni_GetAttributeDataset(this.getHandle());
        DatasetVector datasetVector = null;
        if (l != 0L) {
            datasetVector = new DatasetVector(l, this.m_datasource);
        }
        return datasetVector;
    }

    public double getNoValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridCollectionNative.jni_GetNoValue(this.getHandle());
    }

    public void setNoValue(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetGridCollectionNative.jni_SetNoValue(this.getHandle(), d);
    }

    public PixelFormat getPixelFormat() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetGridCollectionNative.jni_GetPixelFormat(this.getHandle());
        return (PixelFormat)Enum.parseUGCValue(PixelFormat.class, n);
    }

    public boolean getHasPyramid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridCollectionNative.jni_GetHasPyramid(this.getHandle());
    }

    public GeoRegion getClipRegion() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4 == null && (l = DatasetGridCollectionNative.jni_GetClipRegion(this.getHandle())) != 0L) {
            this._$4 = (GeoRegion)Geometry.createInstance(l);
        }
        return this._$4;
    }

    public void setClipRegion(GeoRegion geoRegion) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoRegion == null) {
            if (this._$4 != null) {
                this._$4.clearHandle();
                this._$4 = null;
            }
            DatasetGridCollectionNative.jni_SetClipRegion(this.getHandle(), 0L);
        } else {
            if (geoRegion.getHandle() == 0L) {
                String string = InternalResource.loadString("value", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetGridCollectionNative.jni_SetClipRegion(this.getHandle(), geoRegion.getHandle());
            if (this._$4 != null) {
                this._$4.fromXML(geoRegion.toXML());
            }
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoRegion);
    }

    public Colors getColorTable() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorTable()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 == null && (l = DatasetGridCollectionNative.jni_GetColorTable(this.getHandle())) != 0L) {
            this._$3 = Colors.createInstance(l, false);
        }
        return this._$3;
    }

    public void setColorTable(Colors colors) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColorTable(Colors colors)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (colors == null) {
            String string = InternalResource.loadString("colors", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(colors);
        if (l == 0L) {
            String string = InternalResource.loadString("colors", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Colors colors2 = new Colors(colors);
        long l2 = InternalHandleDisposable.getHandle(colors2);
        DatasetGridCollectionNative.jni_SetColorTable(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive(colors2);
    }

    public boolean add(String string, String string2) {
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("add(String name,String aliasName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string.equals("") || string2.equals("")) {
            String string4 = InternalResource.loadString("params", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        int n = this.getCount();
        boolean bl = DatasetGridCollectionNative.jni_Add(this.getHandle(), string, string2);
        if (bl) {
            this.fireAdded(new DatasetCollectionEvent(this, string2, n, false));
        }
        return bl;
    }

    public boolean add(String string, String string2, boolean bl) {
        boolean bl2;
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("add(String name,String aliasName ,boolean isTop)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string.equals("") || string2.equals("")) {
            String string4 = InternalResource.loadString("params", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        int n = 0;
        if (!bl) {
            n = this.getCount();
        }
        if (bl2 = DatasetGridCollectionNative.jni_Add1(this.getHandle(), string, string2, bl)) {
            this.fireAdded(new DatasetCollectionEvent(this, string2, n, false));
        }
        return bl2;
    }

    public boolean add(Map<String, String> map) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(Map<String, String> values)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Object[] objectArray = map.keySet().toArray();
        int n2 = objectArray.length;
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = (String)objectArray[n];
            stringArray2[n] = map.get(stringArray[n]);
        }
        n = DatasetGridCollectionNative.jni_Add2(this.getHandle(), stringArray, stringArray2) ? 1 : 0;
        if (n != 0) {
            this.fireRequireRefresh(new DatasetCollectionRequireRefreshEvent(this));
        }
        return n != 0;
    }

    public boolean insert(String string, String string2, int n) {
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("insert(String name, String aliasName, int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string.equals("") || string2.equals("")) {
            String string4 = InternalResource.loadString("params", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (n < 0 || n > this.getCount()) {
            String string5 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string5);
        }
        boolean bl = DatasetGridCollectionNative.jni_Insert(this.getHandle(), string, string2, n);
        if (bl) {
            this.fireAdded(new DatasetCollectionEvent(this, string2, n, false));
        }
        return bl;
    }

    public boolean append(DatasetGridCollection datasetGridCollection) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("append(DatasetGridCollection datasetCollection)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (datasetGridCollection.getHandle() == 0L) {
            String string = InternalResource.loadString("datasetCollection", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = DatasetGridCollectionNative.jni_Append(this.getHandle(), datasetGridCollection.getHandle());
        if (bl) {
            this.fireRequireRefresh(new DatasetCollectionRequireRefreshEvent(this));
        }
        return bl;
    }

    public boolean remove(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("remove(String aliasName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        int n = DatasetImageCollectionNative.jni_GetSubDatasetOrder(this.getHandle(), string);
        DatasetCollectionEvent datasetCollectionEvent = new DatasetCollectionEvent(this, string, n, false);
        this.fireRemoving(datasetCollectionEvent);
        if (!datasetCollectionEvent.isCancel()) {
            bl = DatasetGridCollectionNative.jni_Remove(this.getHandle(), string);
            this.fireRemoved(new DatasetCollectionEvent(this, string, n, false));
        }
        return bl;
    }

    public boolean remove(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        String string = DatasetImageCollectionNative.jni_GetAliasName(this.getHandle(), n);
        DatasetCollectionEvent datasetCollectionEvent = new DatasetCollectionEvent(this, string, n, false);
        this.fireRemoving(datasetCollectionEvent);
        if (!datasetCollectionEvent.isCancel()) {
            bl = DatasetGridCollectionNative.jni_Remove1(this.getHandle(), n);
            this.fireRemoved(new DatasetCollectionEvent(this, string, n, false));
        }
        return bl;
    }

    public boolean removeAll() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeAll()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        DatasetCollectionRemoveAllEvent datasetCollectionRemoveAllEvent = new DatasetCollectionRemoveAllEvent(this, false);
        this.fireRemovingAll(datasetCollectionRemoveAllEvent);
        if (!datasetCollectionRemoveAllEvent.isCancel()) {
            bl = DatasetGridCollectionNative.jni_RemoveAll(this.getHandle());
            this.fireRemovedAll(new DatasetCollectionRemoveAllEvent(this, false));
        }
        return bl;
    }

    public boolean synchronize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("synchronize()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = DatasetGridCollectionNative.jni_Synchronize(this.getHandle());
        if (bl) {
            this.fireRequireRefresh(new DatasetCollectionRequireRefreshEvent(this));
        }
        return bl;
    }

    public boolean changeOrder(String string, int n) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("changeOrder(String aliasName, int position)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        int n2 = DatasetGridCollectionNative.jni_GetSubDatasetOrder(this.getHandle(), string);
        boolean bl = DatasetGridCollectionNative.jni_ChangeOrder(this.getHandle(), string, n);
        if (bl) {
            this.fireOrderChanged(new DatasetCollectionChangeOrderEvent(this, string, n2, n));
        }
        return bl;
    }

    public boolean buildPyramid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (this.getHasPyramid()) {
            bl = true;
        } else {
            this.m_selfEventHandle = DatasetGridCollectionNative.jni_NewSelfEventHandle(this);
            bl = DatasetGridCollectionNative.jni_BuildPyramid(this.getHandle(), this.m_selfEventHandle);
            this.clearSelfEventHandle();
        }
        return bl;
    }

    public boolean removePyramid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridCollectionNative.jni_RemovePyramid(this.getHandle());
    }

    public boolean updatePyramid(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        bl = DatasetGridCollectionNative.jni_UpdatePyramid(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        return bl;
    }

    public boolean isAvailableAliasName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("isAvailableAliasName(String name)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        return DatasetGridCollectionNative.jni_IsAvailableAliasName(this.getHandle(), this.m_datasource.getHandle(), string);
    }

    public String getAvailableAliasName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("getAvailableAliasName(String name)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        return DatasetGridCollectionNative.jni_GetAvailableAliasName(this.getHandle(), this.m_datasource.getHandle(), string);
    }

    public boolean rename(String string, String string2) {
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("rename(String aliasName,String newAliasName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string.equals("") || string2.equals("")) {
            String string4 = InternalResource.loadString("params", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        boolean bl = false;
        DatasetCollectionRenameEvent datasetCollectionRenameEvent = new DatasetCollectionRenameEvent(this, string, string2, false);
        this.fireRenaming(datasetCollectionRenameEvent);
        if (!datasetCollectionRenameEvent.isCancel()) {
            bl = DatasetGridCollectionNative.jni_Rename(this.getHandle(), string, string2);
            this.fireRenamed(new DatasetCollectionRenameEvent(this, string, string2, false));
        }
        return bl;
    }

    @Override
    protected void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            DatasetGridCollectionNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    @Override
    protected void clearHandle() {
        if (this._$4 != null) {
            this._$4.clearHandle();
            this._$4 = null;
        }
        if (this._$3 != null) {
            this._$3.clearHandle();
            this._$3 = null;
        }
        this.setHandle(0L);
    }

    public synchronized void addRenamingListener(DatasetCollectionRenameListener datasetCollectionRenameListener) {
        if (this._$12 == null) {
            this._$12 = new Vector();
        }
        if (!this._$12.contains(datasetCollectionRenameListener)) {
            this._$12.add(datasetCollectionRenameListener);
        }
    }

    public synchronized void removeRenamingListener(DatasetCollectionRenameListener datasetCollectionRenameListener) {
        if (this._$12 != null && this._$12.contains(datasetCollectionRenameListener)) {
            this._$12.remove(datasetCollectionRenameListener);
        }
    }

    public synchronized void addRenamedListener(DatasetCollectionRenameListener datasetCollectionRenameListener) {
        if (this._$13 == null) {
            this._$13 = new Vector();
        }
        if (!this._$13.contains(datasetCollectionRenameListener)) {
            this._$13.add(datasetCollectionRenameListener);
        }
    }

    public synchronized void removeRenamedListener(DatasetCollectionRenameListener datasetCollectionRenameListener) {
        if (this._$13 != null && this._$13.contains(datasetCollectionRenameListener)) {
            this._$13.remove(datasetCollectionRenameListener);
        }
    }

    protected void fireRenaming(DatasetCollectionRenameEvent datasetCollectionRenameEvent) {
        if (this._$12 != null) {
            Vector<DatasetCollectionRenameListener> vector = this._$12;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).datasetCollectionRename(datasetCollectionRenameEvent);
            }
        }
    }

    protected void fireRenamed(DatasetCollectionRenameEvent datasetCollectionRenameEvent) {
        if (this._$13 != null) {
            Vector<DatasetCollectionRenameListener> vector = this._$13;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).datasetCollectionRename(datasetCollectionRenameEvent);
            }
        }
    }

    public synchronized void addRemovingListener(DatasetCollectionListener datasetCollectionListener) {
        if (this._$10 == null) {
            this._$10 = new Vector();
        }
        if (!this._$10.contains(datasetCollectionListener)) {
            this._$10.add(datasetCollectionListener);
        }
    }

    public synchronized void removeRemovingListener(DatasetCollectionListener datasetCollectionListener) {
        if (this._$10 != null && this._$10.contains(datasetCollectionListener)) {
            this._$10.remove(datasetCollectionListener);
        }
    }

    public synchronized void addRemovedListener(DatasetCollectionListener datasetCollectionListener) {
        if (this._$9 == null) {
            this._$9 = new Vector();
        }
        if (!this._$9.contains(datasetCollectionListener)) {
            this._$9.add(datasetCollectionListener);
        }
    }

    public synchronized void removeRemovedListener(DatasetCollectionListener datasetCollectionListener) {
        if (this._$9 != null && this._$9.contains(datasetCollectionListener)) {
            this._$9.remove(datasetCollectionListener);
        }
    }

    protected void fireRemoving(DatasetCollectionEvent datasetCollectionEvent) {
        if (this._$10 != null) {
            Vector<DatasetCollectionListener> vector = this._$10;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).datasetCollection(datasetCollectionEvent);
            }
        }
    }

    protected void fireRemoved(DatasetCollectionEvent datasetCollectionEvent) {
        if (this._$9 != null) {
            Vector<DatasetCollectionListener> vector = this._$9;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).datasetCollection(datasetCollectionEvent);
            }
        }
    }

    public synchronized void addRemovingAllListener(DatasetCollectionRemoveAllListener datasetCollectionRemoveAllListener) {
        if (this._$7 == null) {
            this._$7 = new Vector();
        }
        if (!this._$7.contains(datasetCollectionRemoveAllListener)) {
            this._$7.add(datasetCollectionRemoveAllListener);
        }
    }

    public synchronized void removeRemovingAllListener(DatasetCollectionRemoveAllListener datasetCollectionRemoveAllListener) {
        if (this._$7 != null && this._$7.contains(datasetCollectionRemoveAllListener)) {
            this._$7.remove(datasetCollectionRemoveAllListener);
        }
    }

    public synchronized void addRemovedAllListener(DatasetCollectionRemoveAllListener datasetCollectionRemoveAllListener) {
        if (this._$6 == null) {
            this._$6 = new Vector();
        }
        if (!this._$6.contains(datasetCollectionRemoveAllListener)) {
            this._$6.add(datasetCollectionRemoveAllListener);
        }
    }

    public synchronized void removeRemovedAllListener(DatasetCollectionRemoveAllListener datasetCollectionRemoveAllListener) {
        if (this._$6 != null && this._$6.contains(datasetCollectionRemoveAllListener)) {
            this._$6.remove(datasetCollectionRemoveAllListener);
        }
    }

    protected void fireRemovingAll(DatasetCollectionRemoveAllEvent datasetCollectionRemoveAllEvent) {
        if (this._$7 != null) {
            Vector<DatasetCollectionRemoveAllListener> vector = this._$7;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).datasetCollectionRemoveAll(datasetCollectionRemoveAllEvent);
            }
        }
    }

    protected void fireRemovedAll(DatasetCollectionRemoveAllEvent datasetCollectionRemoveAllEvent) {
        if (this._$6 != null) {
            Vector<DatasetCollectionRemoveAllListener> vector = this._$6;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).datasetCollectionRemoveAll(datasetCollectionRemoveAllEvent);
            }
        }
    }

    public synchronized void addAddedListener(DatasetCollectionListener datasetCollectionListener) {
        if (this._$11 == null) {
            this._$11 = new Vector();
        }
        if (!this._$11.contains(datasetCollectionListener)) {
            this._$11.add(datasetCollectionListener);
        }
    }

    public synchronized void removeAddedListener(DatasetCollectionListener datasetCollectionListener) {
        if (this._$11 != null && this._$11.contains(datasetCollectionListener)) {
            this._$11.remove(datasetCollectionListener);
        }
    }

    protected void fireAdded(DatasetCollectionEvent datasetCollectionEvent) {
        if (this._$11 != null) {
            Vector<DatasetCollectionListener> vector = this._$11;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).datasetCollection(datasetCollectionEvent);
            }
        }
    }

    public synchronized void addOrderChangedListener(DatasetCollectionChangeOrderListener datasetCollectionChangeOrderListener) {
        if (this._$8 == null) {
            this._$8 = new Vector();
        }
        if (!this._$8.contains(datasetCollectionChangeOrderListener)) {
            this._$8.add(datasetCollectionChangeOrderListener);
        }
    }

    public synchronized void removeOrderChangedListener(DatasetCollectionChangeOrderListener datasetCollectionChangeOrderListener) {
        if (this._$8 != null && this._$8.contains(datasetCollectionChangeOrderListener)) {
            this._$8.remove(datasetCollectionChangeOrderListener);
        }
    }

    protected void fireOrderChanged(DatasetCollectionChangeOrderEvent datasetCollectionChangeOrderEvent) {
        if (this._$8 != null) {
            Vector<DatasetCollectionChangeOrderListener> vector = this._$8;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).datasetCollectionChangeOrder(datasetCollectionChangeOrderEvent);
            }
        }
    }

    public synchronized void addRequireRefreshListener(DatasetCollectionRequireRefreshListener datasetCollectionRequireRefreshListener) {
        if (this._$5 == null) {
            this._$5 = new Vector();
        }
        if (!this._$5.contains(datasetCollectionRequireRefreshListener)) {
            this._$5.add(datasetCollectionRequireRefreshListener);
        }
    }

    public synchronized void removeRequireRefreshListener(DatasetCollectionRequireRefreshListener datasetCollectionRequireRefreshListener) {
        if (this._$5 != null && this._$5.contains(datasetCollectionRequireRefreshListener)) {
            this._$5.remove(datasetCollectionRequireRefreshListener);
        }
    }

    protected void fireRequireRefresh(DatasetCollectionRequireRefreshEvent datasetCollectionRequireRefreshEvent) {
        if (this._$5 != null) {
            Vector<DatasetCollectionRequireRefreshListener> vector = this._$5;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).datasetCollectionRequireRefresh(datasetCollectionRequireRefreshEvent);
            }
        }
    }
}

