/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry.support;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceException;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.ticket.registry.support.LockingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class JpaLockingStrategy
implements LockingStrategy {
    public static final int DEFAULT_LOCK_TIMEOUT = 3600;
    @NotNull
    @PersistenceContext
    protected EntityManager entityManager;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private String applicationId;
    @NotNull
    private String uniqueId;
    private int lockTimeout = 3600;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public void setApplicationId(String id) {
        this.applicationId = id;
    }

    public void setUniqueId(String id) {
        this.uniqueId = id;
    }

    public void setLockTimeout(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException("Lock timeout must be non-negative.");
        }
        this.lockTimeout = seconds;
    }

    @Override
    @Transactional(readOnly=false)
    public boolean acquire() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        return Conversions.booleanValue((Object)JpaLockingStrategy.acquire_aroundBody1$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    @Override
    @Transactional(readOnly=false)
    public void release() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        JpaLockingStrategy.release_aroundBody3$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Transactional(readOnly=true)
    public String getOwner() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        return (String)JpaLockingStrategy.getOwner_aroundBody5$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public String toString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        return (String)JpaLockingStrategy.toString_aroundBody7$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    private boolean acquire(EntityManager em, Lock lock) {
        lock.setUniqueId(this.uniqueId);
        if (this.lockTimeout > 0) {
            Calendar cal = Calendar.getInstance();
            cal.add(13, this.lockTimeout);
            lock.setExpirationDate(cal.getTime());
        } else {
            lock.setExpirationDate(null);
        }
        boolean success = false;
        try {
            if (lock.getApplicationId() != null) {
                lock = (Lock)em.merge((Object)lock);
            } else {
                lock.setApplicationId(this.applicationId);
                em.persist((Object)lock);
            }
            success = true;
        }
        catch (PersistenceException e) {
            success = false;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{} could not obtain {} lock.", new Object[]{this.uniqueId, this.applicationId, e});
            }
            this.logger.info("{} could not obtain {} lock.", (Object)this.uniqueId, (Object)this.applicationId);
        }
        return success;
    }

    static {
        JpaLockingStrategy.ajc$preClinit();
    }

    private static final /* synthetic */ boolean acquire_aroundBody0(JpaLockingStrategy ajc$this, JoinPoint joinPoint) {
        Lock lock;
        try {
            lock = (Lock)ajc$this.entityManager.find(Lock.class, (Object)ajc$this.applicationId, LockModeType.PESSIMISTIC_WRITE);
        }
        catch (PersistenceException e) {
            ajc$this.logger.debug("{} failed querying for {} lock.", new Object[]{ajc$this.uniqueId, ajc$this.applicationId, e});
            return false;
        }
        boolean result = false;
        if (lock != null) {
            Date expDate = lock.getExpirationDate();
            if (lock.getUniqueId() == null) {
                ajc$this.logger.debug("{} trying to acquire {} lock.", (Object)ajc$this.uniqueId, (Object)ajc$this.applicationId);
                result = ajc$this.acquire(ajc$this.entityManager, lock);
            } else if (expDate != null && new Date().after(expDate)) {
                ajc$this.logger.debug("{} trying to acquire expired {} lock.", (Object)ajc$this.uniqueId, (Object)ajc$this.applicationId);
                result = ajc$this.acquire(ajc$this.entityManager, lock);
            }
        } else {
            ajc$this.logger.debug("Creating {} lock initially held by {}.", (Object)ajc$this.applicationId, (Object)ajc$this.uniqueId);
            result = ajc$this.acquire(ajc$this.entityManager, new Lock());
        }
        return result;
    }

    private static final /* synthetic */ Object acquire_aroundBody1$advice(JpaLockingStrategy ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = Conversions.booleanObject((boolean)JpaLockingStrategy.acquire_aroundBody0(ajc$this, (JoinPoint)proceedingJoinPoint2));
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static final /* synthetic */ void release_aroundBody2(JpaLockingStrategy ajc$this, JoinPoint joinPoint) {
        Lock lock = (Lock)ajc$this.entityManager.find(Lock.class, (Object)ajc$this.applicationId, LockModeType.PESSIMISTIC_WRITE);
        if (lock == null) {
            return;
        }
        String owner = lock.getUniqueId();
        if (!ajc$this.uniqueId.equals(owner)) {
            throw new IllegalStateException("Cannot release lock owned by " + owner);
        }
        lock.setUniqueId(null);
        lock.setExpirationDate(null);
        ajc$this.logger.debug("Releasing {} lock held by {}.", (Object)ajc$this.applicationId, (Object)ajc$this.uniqueId);
        ajc$this.entityManager.persist((Object)lock);
    }

    private static final /* synthetic */ Object release_aroundBody3$advice(JpaLockingStrategy ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            JpaLockingStrategy.release_aroundBody2(ajc$this, (JoinPoint)proceedingJoinPoint2);
            object = returnVal = null;
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static final /* synthetic */ String getOwner_aroundBody4(JpaLockingStrategy ajc$this, JoinPoint joinPoint) {
        Lock lock = (Lock)ajc$this.entityManager.find(Lock.class, (Object)ajc$this.applicationId);
        if (lock != null) {
            return lock.getUniqueId();
        }
        return null;
    }

    private static final /* synthetic */ Object getOwner_aroundBody5$advice(JpaLockingStrategy ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        String string;
        String returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            string = returnVal = JpaLockingStrategy.getOwner_aroundBody4(ajc$this, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return string;
    }

    private static final /* synthetic */ Object toString_aroundBody7$advice(JpaLockingStrategy ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        String string;
        String returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            string = returnVal = ajc$this.uniqueId;
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return string;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JpaLockingStrategy.java", JpaLockingStrategy.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "acquire", "org.jasig.cas.ticket.registry.support.JpaLockingStrategy", "", "", "", "boolean"), 113);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "release", "org.jasig.cas.ticket.registry.support.JpaLockingStrategy", "", "", "", "void"), 145);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOwner", "org.jasig.cas.ticket.registry.support.JpaLockingStrategy", "", "", "", "java.lang.String"), 171);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "org.jasig.cas.ticket.registry.support.JpaLockingStrategy", "", "", "", "java.lang.String"), 182);
    }

    @Entity
    @Table(name="locks")
    public static class Lock {
        @Id
        @Column(name="application_id")
        private String applicationId;
        @Column(name="unique_id")
        private String uniqueId;
        @Temporal(value=TemporalType.TIMESTAMP)
        @Column(name="expiration_date")
        private Date expirationDate;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        public String getApplicationId() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            return (String)Lock.getApplicationId_aroundBody1$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
        }

        public void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public String getUniqueId() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            return (String)Lock.getUniqueId_aroundBody3$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
        }

        public void setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        public Date getExpirationDate() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
            return (Date)Lock.getExpirationDate_aroundBody5$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
        }

        public void setExpirationDate(Date expirationDate) {
            this.expirationDate = expirationDate;
        }

        static {
            Lock.ajc$preClinit();
        }

        private static final /* synthetic */ Object getApplicationId_aroundBody1$advice(Lock ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
            String string;
            String returnVal = null;
            Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
            String methodName = proceedingJoinPoint.getSignature().getName();
            try {
                if (log.isTraceEnabled()) {
                    Object[] args = proceedingJoinPoint.getArgs();
                    String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                    log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
                }
                ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
                string = returnVal = ajc$this.applicationId;
            }
            catch (Throwable throwable) {
                if (log.isTraceEnabled()) {
                    log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
                }
                throw throwable;
            }
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            return string;
        }

        private static final /* synthetic */ Object getUniqueId_aroundBody3$advice(Lock ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
            String string;
            String returnVal = null;
            Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
            String methodName = proceedingJoinPoint.getSignature().getName();
            try {
                if (log.isTraceEnabled()) {
                    Object[] args = proceedingJoinPoint.getArgs();
                    String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                    log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
                }
                ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
                string = returnVal = ajc$this.uniqueId;
            }
            catch (Throwable throwable) {
                if (log.isTraceEnabled()) {
                    log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
                }
                throw throwable;
            }
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            return string;
        }

        private static final /* synthetic */ Object getExpirationDate_aroundBody5$advice(Lock ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
            Date date;
            Date returnVal = null;
            Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
            String methodName = proceedingJoinPoint.getSignature().getName();
            try {
                if (log.isTraceEnabled()) {
                    Object[] args = proceedingJoinPoint.getArgs();
                    String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                    log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
                }
                ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
                date = returnVal = ajc$this.expirationDate;
            }
            catch (Throwable throwable) {
                if (log.isTraceEnabled()) {
                    log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? ((Object)returnVal).toString() : "null") + "].");
                }
                throw throwable;
            }
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? ((Object)returnVal).toString() : "null") + "].");
            }
            return date;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("JpaLockingStrategy.java", Lock.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getApplicationId", "org.jasig.cas.ticket.registry.support.JpaLockingStrategy$Lock", "", "", "", "java.lang.String"), 245);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUniqueId", "org.jasig.cas.ticket.registry.support.JpaLockingStrategy$Lock", "", "", "", "java.lang.String"), 259);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getExpirationDate", "org.jasig.cas.ticket.registry.support.JpaLockingStrategy$Lock", "", "", "", "java.util.Date"), 273);
        }
    }
}

