/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.data.DatasetType;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Resources;
import com.supermap.data.Toolkit;
import com.supermap.mapping.Layer;
import com.supermap.mapping.ThemeGraphItem;
import com.supermap.ui.NodeDataType;
import com.supermap.ui.TreeNodeData;
import com.supermap.ui.TreeNodeDecorator;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

class ThemeGraphItemNodeDecorator
implements TreeNodeDecorator {
    ThemeGraphItemNodeDecorator() {
    }

    public void decorate(JLabel jLabel, TreeNodeData treeNodeData) {
        if (treeNodeData.getType().equals((Object)NodeDataType.THEMEGRAPHITEM)) {
            ThemeGraphItem themeGraphItem = (ThemeGraphItem)treeNodeData.getData();
            jLabel.setText(themeGraphItem.getCaption());
            Layer layer = treeNodeData.getParentLayer();
            Resources resources = layer.getDataset().getDatasource().getWorkspace().getResources();
            BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
            Graphics graphics = bufferedImage.getGraphics();
            ImageIcon imageIcon = (ImageIcon)jLabel.getIcon();
            Geometry geometry = this._$1(DatasetType.REGION);
            GeoStyle geoStyle = themeGraphItem.getUniformStyle();
            geometry.setStyle(geoStyle);
            Toolkit.draw((Geometry)geometry, (Resources)resources, (Graphics)graphics);
            imageIcon.setImage(bufferedImage);
        }
    }

    private Geometry _$1(DatasetType datasetType) {
        if (datasetType.equals((Object)DatasetType.POINT)) {
            GeoPoint geoPoint = new GeoPoint();
            return geoPoint;
        }
        if (datasetType.equals((Object)DatasetType.LINE)) {
            Point2D[] point2DArray = new Point2D[]{new Point2D(0.0, 16.0), new Point2D(4.0, 0.0), new Point2D(12.0, 16.0), new Point2D(16.0, 0.0)};
            Point2Ds point2Ds = new Point2Ds(point2DArray);
            GeoLine geoLine = new GeoLine(point2Ds);
            return geoLine;
        }
        if (datasetType.equals((Object)DatasetType.REGION) || datasetType.equals((Object)DatasetType.GRID)) {
            Point2D[] point2DArray = new Point2D[]{new Point2D(1.0, 15.0), new Point2D(1.0, 5.0), new Point2D(10.0, 1.0), new Point2D(15.0, 5.0), new Point2D(15.0, 15.0), new Point2D(1.0, 15.0)};
            Point2Ds point2Ds = new Point2Ds(point2DArray);
            GeoRegion geoRegion = new GeoRegion(point2Ds);
            return geoRegion;
        }
        return null;
    }
}

