/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.smsserver.interfaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.smslib.InboundMessage;
import org.smslib.OutboundMessage;
import org.smslib.helper.Logger;
import org.smslib.smsserver.SMSServer;

public class Interface<T> {
    private String infId;
    private Properties props;
    private SMSServer server;
    private InterfaceTypes type;
    private String description;
    private Map<Long, T> messageIdCache;

    public Interface(String myInfId, Properties myProps, SMSServer myServer, InterfaceTypes myType) {
        this.infId = myInfId;
        this.props = myProps;
        this.server = myServer;
        this.type = myType;
        this.messageIdCache = new HashMap<Long, T>();
    }

    public final SMSServer getServer() {
        return this.server;
    }

    public String getId() {
        return this.infId;
    }

    public void callReceived(String gtwId, String callerId) throws Exception {
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String myDescription) {
        this.description = myDescription;
    }

    public final Map<Long, T> getMessageCache() {
        return this.messageIdCache;
    }

    public Collection<OutboundMessage> getMessagesToSend() throws Exception {
        return new ArrayList<OutboundMessage>();
    }

    public int getPendingMessagesToSend() throws Exception {
        return -1;
    }

    public final String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public final String getProperty(String key, String defaultValue) {
        String value = this.props.getProperty(this.infId + "." + key, defaultValue);
        if (value == null || value.length() == 0) {
            value = defaultValue;
        }
        return value;
    }

    public final InterfaceTypes getType() {
        return this.type;
    }

    public final boolean isInbound() {
        return InterfaceTypes.INBOUND == this.type || InterfaceTypes.INOUTBOUND == this.type;
    }

    public final boolean isOutbound() {
        return InterfaceTypes.OUTBOUND == this.type || InterfaceTypes.INOUTBOUND == this.type;
    }

    public void markMessage(OutboundMessage msg) throws Exception {
    }

    public void markMessages(Collection<OutboundMessage> msgList) throws Exception {
        for (OutboundMessage msg : msgList) {
            this.markMessage(msg);
        }
    }

    public void messagesReceived(Collection<InboundMessage> msgList) throws Exception {
    }

    public void start() throws Exception {
        Logger.getInstance().logInfo("SMSServer: interface: " + this.getClass().getName() + " started.", null, null);
    }

    public void stop() throws Exception {
        Logger.getInstance().logInfo("SMSServer: interface: " + this.getClass().getName() + " stopped.", null, null);
    }

    public static enum InterfaceTypes {
        INBOUND,
        OUTBOUND,
        INOUTBOUND;

    }
}

