/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.surround.query;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.queryParser.surround.query.BasicQueryFactory;
import org.apache.lucene.queryParser.surround.query.ComposedQuery;
import org.apache.lucene.queryParser.surround.query.DistanceSubQuery;
import org.apache.lucene.queryParser.surround.query.SpanNearClauseFactory;
import org.apache.lucene.queryParser.surround.query.SrndBooleanQuery;
import org.apache.lucene.queryParser.surround.query.SrndQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrQuery
extends ComposedQuery
implements DistanceSubQuery {
    public OrQuery(List<SrndQuery> queries, boolean infix, String opName) {
        super(queries, infix, opName);
    }

    @Override
    public Query makeLuceneQueryFieldNoBoost(String fieldName, BasicQueryFactory qf) {
        return SrndBooleanQuery.makeBooleanQuery(this.makeLuceneSubQueriesField(fieldName, qf), BooleanClause.Occur.SHOULD);
    }

    @Override
    public String distanceSubQueryNotAllowed() {
        Iterator sqi = this.getSubQueriesIterator();
        while (sqi.hasNext()) {
            SrndQuery leq = (SrndQuery)sqi.next();
            if (leq instanceof DistanceSubQuery) {
                String m = ((DistanceSubQuery)((Object)leq)).distanceSubQueryNotAllowed();
                if (m == null) continue;
                return m;
            }
            return "subquery not allowed: " + leq.toString();
        }
        return null;
    }

    @Override
    public void addSpanQueries(SpanNearClauseFactory sncf) throws IOException {
        Iterator sqi = this.getSubQueriesIterator();
        while (sqi.hasNext()) {
            ((DistanceSubQuery)sqi.next()).addSpanQueries(sncf);
        }
    }
}

