/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws22.spi;

import java.util.Arrays;
import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.spi.Invoker;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.EndpointUtils;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.context.WebServiceContextImpl;
import org.apache.cxf.jaxws22.JAXWS22Invoker;

public class ProviderImpl
extends org.apache.cxf.jaxws.spi.ProviderImpl {
    @Override
    protected EndpointImpl createEndpointImpl(Bus bus, String bindingId, Object implementor, WebServiceFeature ... features) {
        if (ProviderImpl.isJaxWs22()) {
            return new org.apache.cxf.jaxws22.EndpointImpl(bus, implementor, bindingId, features);
        }
        return super.createEndpointImpl(bus, bindingId, implementor, features);
    }

    public Endpoint createEndpoint(String bindingId, Class<?> implementorClass, Invoker invoker, WebServiceFeature ... features) {
        if (EndpointUtils.isValidImplementor(implementorClass)) {
            Bus bus = BusFactory.getThreadDefaultBus();
            JaxWsServerFactoryBean factory = new JaxWsServerFactoryBean();
            if (features != null) {
                factory.getJaxWsServiceFactory().setWsFeatures(Arrays.asList(features));
            }
            if (invoker != null) {
                factory.setInvoker(new JAXWS22Invoker(invoker));
                try {
                    invoker.inject((WebServiceContext)new WebServiceContextImpl());
                }
                catch (Exception e) {
                    throw new WebServiceException(new Message("ENDPOINT_CREATION_FAILED_MSG", LOG, new Object[0]).toString(), (Throwable)e);
                }
            }
            org.apache.cxf.jaxws22.EndpointImpl ep = new org.apache.cxf.jaxws22.EndpointImpl(bus, null, factory);
            ep.setImplementorClass(implementorClass);
            return ep;
        }
        throw new WebServiceException(new Message("INVALID_IMPLEMENTOR_EXC", LOG, new Object[0]).toString());
    }
}

