/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.threading;

import org.smslib.helper.Logger;

public abstract class AServiceThread
extends Thread {
    private int delay;
    private int initialDelay;
    private boolean enabled;
    private boolean canceled;

    public AServiceThread(String name, int delay, int initialDelay, boolean enabled) {
        this.setName(name);
        this.setDelay(delay);
        if (enabled) {
            this.enable();
        } else {
            this.disable();
        }
        this.canceled = false;
        Logger.getInstance().logDebug("Initialized.", null, null);
        this.start();
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(int initialDelay) {
        this.initialDelay = initialDelay;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void cancel() {
        this.canceled = true;
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (!this.isCanceled()) {
            try {
                Logger.getInstance().logDebug(this.isEnabled() ? "Running..." : "** disabled **", null, null);
                if (this.isEnabled()) {
                    this.process();
                }
                AServiceThread.sleep(this.getDelay());
            }
            catch (InterruptedException e) {
                if (this.isCanceled()) {
                    Logger.getInstance().logDebug("Stopped.", null, null);
                    break;
                }
                Logger.getInstance().logDebug("Interrupted!", null, null);
            }
            catch (Exception e) {
                Logger.getInstance().logError("Error!", e, null);
            }
        }
    }

    public abstract void process() throws Exception;
}

