/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ehcache.annotations.key;

import com.google.common.collect.MapMaker;
import com.googlecode.ehcache.annotations.key.ReflectionHelper;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CachingReflectionHelper
implements ReflectionHelper {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<Class<?>, Set<ImplementsMethod>> implementsCache = new MapMaker().weakKeys().makeMap();

    private Map<Class<?>, Set<ImplementsMethod>> getCache() {
        return this.implementsCache;
    }

    @Override
    public boolean implementsHashCode(Object element) {
        return this.doesImplement(element.getClass(), ImplementsMethod.HASH_CODE);
    }

    @Override
    public boolean implementsEquals(Object element) {
        return this.doesImplement(element.getClass(), ImplementsMethod.EQUALS);
    }

    @Override
    public boolean implementsToString(Object element) {
        return this.doesImplement(element.getClass(), ImplementsMethod.TO_STRING);
    }

    public void clearCache() {
        Map<Class<?>, Set<ImplementsMethod>> cache = this.getCache();
        cache.clear();
    }

    private boolean doesImplement(Class<?> elementClass, ImplementsMethod method) {
        Map<Class<?>, Set<ImplementsMethod>> cache = this.getCache();
        Set<ImplementsMethod> methodCache = cache.get(elementClass);
        if (methodCache == null) {
            methodCache = EnumSet.noneOf(ImplementsMethod.class);
            cache.put(elementClass, methodCache);
            final Set<ImplementsMethod> implementsSet = methodCache;
            ReflectionUtils.doWithMethods(elementClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    if (implementsSet.size() == 3 || method.getDeclaringClass() == Object.class) {
                        return;
                    }
                    if (ReflectionUtils.isEqualsMethod((Method)method)) {
                        implementsSet.add(ImplementsMethod.EQUALS);
                    } else if (ReflectionUtils.isHashCodeMethod((Method)method)) {
                        implementsSet.add(ImplementsMethod.HASH_CODE);
                    } else if (ReflectionUtils.isToStringMethod((Method)method)) {
                        implementsSet.add(ImplementsMethod.TO_STRING);
                    }
                }
            });
        }
        return methodCache.contains((Object)method);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ImplementsMethod {
        HASH_CODE,
        EQUALS,
        TO_STRING;

    }
}

