/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import junit.framework.AssertionFailedError;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ManagementService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.ProcessEngineImpl;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandConfig;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.jobexecutor.JobExecutor;
import org.activiti.engine.impl.test.PvmTestCase;
import org.activiti.engine.impl.test.TestHelper;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.junit.Assert;

public abstract class AbstractActivitiTestCase
extends PvmTestCase {
    private static final List<String> TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK = Arrays.asList("ACT_GE_PROPERTY");
    protected ProcessEngine processEngine;
    protected String deploymentIdFromDeploymentAnnotation;
    protected List<String> deploymentIdsForAutoCleanup = new ArrayList<String>();
    protected Throwable exception;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected FormService formService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected ManagementService managementService;

    protected void setUp() throws Exception {
        super.setUp();
        this.identityService.setAuthenticatedUserId(null);
    }

    protected abstract void initializeProcessEngine();

    protected void closeDownProcessEngine() {
    }

    public void runBare() throws Throwable {
        this.initializeProcessEngine();
        if (this.repositoryService == null) {
            this.initializeServices();
        }
        try {
            this.deploymentIdFromDeploymentAnnotation = TestHelper.annotationDeploymentSetUp(this.processEngine, ((Object)((Object)this)).getClass(), this.getName());
            super.runBare();
        }
        catch (AssertionFailedError e) {
            log.error("                                                                                           ");
            log.error("ASSERTION FAILED: {}", (Object)e, (Object)e);
            this.exception = e;
            throw e;
        }
        catch (Throwable e) {
            log.error("                                                                                           ");
            log.error("EXCEPTION: {}", (Object)e, (Object)e);
            this.exception = e;
            throw e;
        }
        finally {
            if (this.deploymentIdFromDeploymentAnnotation != null) {
                TestHelper.annotationDeploymentTearDown(this.processEngine, this.deploymentIdFromDeploymentAnnotation, ((Object)((Object)this)).getClass(), this.getName());
                this.deploymentIdFromDeploymentAnnotation = null;
            }
            for (String autoDeletedDeploymentId : this.deploymentIdsForAutoCleanup) {
                this.repositoryService.deleteDeployment(autoDeletedDeploymentId, true);
            }
            this.deploymentIdsForAutoCleanup.clear();
            this.assertAndEnsureCleanDb();
            this.processEngineConfiguration.getClock().reset();
            this.closeDownProcessEngine();
        }
    }

    protected void assertAndEnsureCleanDb() throws Throwable {
        log.debug("verifying that db is clean after test");
        Map<String, Long> tableCounts = this.managementService.getTableCount();
        StringBuilder outputMessage = new StringBuilder();
        for (String tableName : tableCounts.keySet()) {
            Long count;
            String tableNameWithoutPrefix = tableName.replace(this.processEngineConfiguration.getDatabaseTablePrefix(), "");
            if (TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.contains(tableNameWithoutPrefix) || (count = tableCounts.get(tableName)) == 0L) continue;
            outputMessage.append("  " + tableName + ": " + count + " record(s) ");
        }
        if (outputMessage.length() > 0) {
            outputMessage.insert(0, "DB NOT CLEAN: \n");
            log.error("                                                                                           ");
            log.error(outputMessage.toString());
            log.info("dropping and recreating db");
            CommandExecutor commandExecutor = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration().getCommandExecutor();
            CommandConfig config = new CommandConfig().transactionNotSupported();
            commandExecutor.execute(config, new Command<Object>(){

                @Override
                public Object execute(CommandContext commandContext) {
                    DbSqlSession session = commandContext.getSession(DbSqlSession.class);
                    session.dbSchemaDrop();
                    session.dbSchemaCreate();
                    return null;
                }
            });
            if (this.exception != null) {
                throw this.exception;
            }
            Assert.fail((String)outputMessage.toString());
        } else {
            log.info("database was clean");
        }
    }

    protected void initializeServices() {
        this.processEngineConfiguration = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration();
        this.repositoryService = this.processEngine.getRepositoryService();
        this.runtimeService = this.processEngine.getRuntimeService();
        this.taskService = this.processEngine.getTaskService();
        this.formService = this.processEngine.getFormService();
        this.historyService = this.processEngine.getHistoryService();
        this.identityService = this.processEngine.getIdentityService();
        this.managementService = this.processEngine.getManagementService();
    }

    public void assertProcessEnded(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance != null) {
            throw new AssertionFailedError("Expected finished process instance '" + processInstanceId + "' but it was still in the db");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForJobExecutorToProcessAllJobs(long maxMillisToWait, long intervalMillis) {
        JobExecutor jobExecutor = this.processEngineConfiguration.getJobExecutor();
        jobExecutor.start();
        try {
            Timer timer = new Timer();
            InteruptTask task = new InteruptTask(Thread.currentThread());
            timer.schedule((TimerTask)task, maxMillisToWait);
            boolean areJobsAvailable = true;
            try {
                while (areJobsAvailable && !task.isTimeLimitExceeded()) {
                    Thread.sleep(intervalMillis);
                    try {
                        areJobsAvailable = this.areJobsAvailable();
                    }
                    catch (Throwable t) {}
                }
            }
            catch (InterruptedException e) {
            }
            finally {
                timer.cancel();
            }
            if (areJobsAvailable) {
                throw new ActivitiException("time limit of " + maxMillisToWait + " was exceeded");
            }
        }
        finally {
            jobExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForJobExecutorOnCondition(long maxMillisToWait, long intervalMillis, Callable<Boolean> condition) {
        JobExecutor jobExecutor = this.processEngineConfiguration.getJobExecutor();
        jobExecutor.start();
        try {
            Timer timer = new Timer();
            InteruptTask task = new InteruptTask(Thread.currentThread());
            timer.schedule((TimerTask)task, maxMillisToWait);
            boolean conditionIsViolated = true;
            try {
                while (conditionIsViolated) {
                    Thread.sleep(intervalMillis);
                    conditionIsViolated = condition.call() == false;
                }
            }
            catch (InterruptedException e) {
            }
            catch (Exception e) {
                throw new ActivitiException("Exception while waiting on condition: " + e.getMessage(), e);
            }
            finally {
                timer.cancel();
            }
            if (conditionIsViolated) {
                throw new ActivitiException("time limit of " + maxMillisToWait + " was exceeded");
            }
        }
        finally {
            jobExecutor.shutdown();
        }
    }

    public boolean areJobsAvailable() {
        return !this.managementService.createJobQuery().executable().list().isEmpty();
    }

    public BpmnModel createOneTaskTestProcess() {
        BpmnModel model = new BpmnModel();
        Process process = new Process();
        model.addProcess(process);
        process.setId("oneTaskProcess");
        process.setName("The one task process");
        StartEvent startEvent = new StartEvent();
        startEvent.setId("start");
        process.addFlowElement((FlowElement)startEvent);
        UserTask userTask = new UserTask();
        userTask.setName("The Task");
        userTask.setId("theTask");
        userTask.setAssignee("kermit");
        process.addFlowElement((FlowElement)userTask);
        EndEvent endEvent = new EndEvent();
        endEvent.setId("theEnd");
        process.addFlowElement((FlowElement)endEvent);
        process.addFlowElement((FlowElement)new SequenceFlow("start", "theTask"));
        process.addFlowElement((FlowElement)new SequenceFlow("theTask", "theEnd"));
        return model;
    }

    public BpmnModel createTwoTasksTestProcess() {
        BpmnModel model = new BpmnModel();
        Process process = new Process();
        model.addProcess(process);
        process.setId("twoTasksProcess");
        process.setName("The two tasks process");
        StartEvent startEvent = new StartEvent();
        startEvent.setId("start");
        process.addFlowElement((FlowElement)startEvent);
        UserTask userTask = new UserTask();
        userTask.setName("The First Task");
        userTask.setId("task1");
        userTask.setAssignee("kermit");
        process.addFlowElement((FlowElement)userTask);
        UserTask userTask2 = new UserTask();
        userTask2.setName("The Second Task");
        userTask2.setId("task2");
        userTask2.setAssignee("kermit");
        process.addFlowElement((FlowElement)userTask2);
        EndEvent endEvent = new EndEvent();
        endEvent.setId("theEnd");
        process.addFlowElement((FlowElement)endEvent);
        process.addFlowElement((FlowElement)new SequenceFlow("start", "task1"));
        process.addFlowElement((FlowElement)new SequenceFlow("start", "task2"));
        process.addFlowElement((FlowElement)new SequenceFlow("task1", "theEnd"));
        process.addFlowElement((FlowElement)new SequenceFlow("task2", "theEnd"));
        return model;
    }

    public String deployOneTaskTestProcess() {
        BpmnModel bpmnModel = this.createOneTaskTestProcess();
        Deployment deployment = this.repositoryService.createDeployment().addBpmnModel("oneTasktest.bpmn20.xml", bpmnModel).deploy();
        this.deploymentIdsForAutoCleanup.add(deployment.getId());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        return processDefinition.getId();
    }

    public String deployTwoTasksTestProcess() {
        BpmnModel bpmnModel = this.createTwoTasksTestProcess();
        Deployment deployment = this.repositoryService.createDeployment().addBpmnModel("twoTasksTestProcess.bpmn20.xml", bpmnModel).deploy();
        this.deploymentIdsForAutoCleanup.add(deployment.getId());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        return processDefinition.getId();
    }

    private static class InteruptTask
    extends TimerTask {
        protected boolean timeLimitExceeded = false;
        protected Thread thread;

        public InteruptTask(Thread thread) {
            this.thread = thread;
        }

        public boolean isTimeLimitExceeded() {
            return this.timeLimitExceeded;
        }

        @Override
        public void run() {
            this.timeLimitExceeded = true;
            this.thread.interrupt();
        }
    }
}

