/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.validation;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jasig.cas.client.authentication.AttributePrincipalImpl;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.AbstractUrlBasedTicketValidator;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.AssertionImpl;
import org.jasig.cas.client.validation.TicketValidationException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.common.IdentifierGenerator;
import org.opensaml.common.impl.SecureRandomIdentifierGenerator;
import org.opensaml.saml1.core.Attribute;
import org.opensaml.saml1.core.AttributeStatement;
import org.opensaml.saml1.core.AuthenticationStatement;
import org.opensaml.saml1.core.Response;
import org.opensaml.saml1.core.Subject;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.schema.XSAny;
import org.opensaml.xml.schema.XSString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Saml11TicketValidator
extends AbstractUrlBasedTicketValidator {
    private long tolerance = 1000L;
    private final BasicParserPool basicParserPool = new BasicParserPool();
    private final IdentifierGenerator identifierGenerator;

    public Saml11TicketValidator(String casServerUrlPrefix) {
        super(casServerUrlPrefix);
        this.basicParserPool.setNamespaceAware(true);
        try {
            this.identifierGenerator = new SecureRandomIdentifierGenerator();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String getUrlSuffix() {
        return "samlValidate";
    }

    @Override
    protected void populateUrlAttributeMap(Map<String, String> urlParameters) {
        String service = urlParameters.get("service");
        urlParameters.remove("service");
        urlParameters.remove("ticket");
        urlParameters.put("TARGET", service);
    }

    @Override
    protected void setDisableXmlSchemaValidation(boolean disabled) {
        if (disabled) {
            this.basicParserPool.setSchema(null);
        }
    }

    protected byte[] getBytes(String text) {
        try {
            return CommonUtils.isNotBlank(this.getEncoding()) ? text.getBytes(this.getEncoding()) : text.getBytes();
        }
        catch (Exception e) {
            return text.getBytes();
        }
    }

    @Override
    protected Assertion parseResponseFromServer(String response) throws TicketValidationException {
        try {
            Document responseDocument = this.basicParserPool.parse((InputStream)new ByteArrayInputStream(this.getBytes(response)));
            Element responseRoot = responseDocument.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(responseRoot);
            Envelope envelope = (Envelope)unmarshaller.unmarshall(responseRoot);
            Response samlResponse = (Response)envelope.getBody().getOrderedChildren().get(0);
            List assertions = samlResponse.getAssertions();
            if (assertions.isEmpty()) {
                throw new TicketValidationException("No assertions found.");
            }
            for (org.opensaml.saml1.core.Assertion assertion : assertions) {
                if (!this.isValidAssertion(assertion)) continue;
                AuthenticationStatement authenticationStatement = this.getSAMLAuthenticationStatement(assertion);
                if (authenticationStatement == null) {
                    throw new TicketValidationException("No AuthentiationStatement found in SAML Assertion.");
                }
                Subject subject = authenticationStatement.getSubject();
                if (subject == null) {
                    throw new TicketValidationException("No Subject found in SAML Assertion.");
                }
                List<Attribute> attributes = this.getAttributesFor(assertion, subject);
                HashMap<String, Object> personAttributes = new HashMap<String, Object>();
                for (Attribute samlAttribute : attributes) {
                    List<?> values = this.getValuesFrom(samlAttribute);
                    personAttributes.put(samlAttribute.getAttributeName(), values.size() == 1 ? values.get(0) : values);
                }
                AttributePrincipalImpl principal = new AttributePrincipalImpl(subject.getNameIdentifier().getNameIdentifier(), personAttributes);
                HashMap<String, Object> authenticationAttributes = new HashMap<String, Object>();
                authenticationAttributes.put("samlAuthenticationStatement::authMethod", authenticationStatement.getAuthenticationMethod());
                DateTime notBefore = assertion.getConditions().getNotBefore();
                DateTime notOnOrAfter = assertion.getConditions().getNotOnOrAfter();
                DateTime authenticationInstant = authenticationStatement.getAuthenticationInstant();
                return new AssertionImpl(principal, notBefore.toDate(), notOnOrAfter.toDate(), authenticationInstant.toDate(), authenticationAttributes);
            }
        }
        catch (UnmarshallingException e) {
            throw new TicketValidationException(e);
        }
        catch (XMLParserException e) {
            throw new TicketValidationException(e);
        }
        throw new TicketValidationException("No Assertion found within valid time range.  Either there's a replay of the ticket or there's clock drift. Check tolerance range, or server/client synchronization.");
    }

    private boolean isValidAssertion(org.opensaml.saml1.core.Assertion assertion) {
        DateTime notBefore = assertion.getConditions().getNotBefore();
        DateTime notOnOrAfter = assertion.getConditions().getNotOnOrAfter();
        if (notBefore == null || notOnOrAfter == null) {
            this.logger.debug("Assertion has no bounding dates. Will not process.");
            return false;
        }
        DateTime currentTime = new DateTime(DateTimeZone.UTC);
        Interval validityRange = new Interval((ReadableInstant)notBefore.minus(this.tolerance), (ReadableInstant)notOnOrAfter.plus(this.tolerance));
        if (validityRange.contains((ReadableInstant)currentTime)) {
            this.logger.debug("Current time is within the interval validity.");
            return true;
        }
        if (currentTime.isBefore((ReadableInstant)validityRange.getStart())) {
            this.logger.debug("skipping assertion that's not yet valid...");
            return false;
        }
        this.logger.debug("skipping expired assertion...");
        return false;
    }

    private AuthenticationStatement getSAMLAuthenticationStatement(org.opensaml.saml1.core.Assertion assertion) {
        List statements = assertion.getAuthenticationStatements();
        if (statements.isEmpty()) {
            return null;
        }
        return (AuthenticationStatement)statements.get(0);
    }

    private List<Attribute> getAttributesFor(org.opensaml.saml1.core.Assertion assertion, Subject subject) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (AttributeStatement attribute : assertion.getAttributeStatements()) {
            if (!subject.getNameIdentifier().getNameIdentifier().equals(attribute.getSubject().getNameIdentifier().getNameIdentifier())) continue;
            attributes.addAll(attribute.getAttributes());
        }
        return attributes;
    }

    private List<?> getValuesFrom(Attribute attribute) {
        ArrayList<String> list = new ArrayList<String>();
        for (XMLObject o : attribute.getAttributeValues()) {
            if (o instanceof XSAny) {
                list.add(((XSAny)o).getTextContent());
                continue;
            }
            if (o instanceof XSString) {
                list.add(((XSString)o).getValue());
                continue;
            }
            list.add(o.toString());
        }
        return list;
    }

    @Override
    protected String retrieveResponseFromServer(URL validationUrl, String ticket) {
        String string;
        String MESSAGE_TO_SEND = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Header/><SOAP-ENV:Body><samlp:Request xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"  MajorVersion=\"1\" MinorVersion=\"1\" RequestID=\"" + this.identifierGenerator.generateIdentifier() + "\" IssueInstant=\"" + CommonUtils.formatForUtcTime(new Date()) + "\">" + "<samlp:AssertionArtifact>" + ticket + "</samlp:AssertionArtifact></samlp:Request></SOAP-ENV:Body></SOAP-ENV:Envelope>";
        HttpURLConnection conn = null;
        DataOutputStream out = null;
        BufferedReader in = null;
        try {
            String line;
            conn = this.getURLConnectionFactory().buildHttpURLConnection(validationUrl.openConnection());
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "text/xml");
            conn.setRequestProperty("Content-Length", Integer.toString(MESSAGE_TO_SEND.length()));
            conn.setRequestProperty("SOAPAction", "http://www.oasis-open.org/committees/security");
            conn.setUseCaches(false);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            out = new DataOutputStream(conn.getOutputStream());
            out.writeBytes(MESSAGE_TO_SEND);
            out.flush();
            in = new BufferedReader(CommonUtils.isNotBlank(this.getEncoding()) ? new InputStreamReader(conn.getInputStream(), Charset.forName(this.getEncoding())) : new InputStreamReader(conn.getInputStream()));
            StringBuilder buffer = new StringBuilder(256);
            while ((line = in.readLine()) != null) {
                buffer.append(line);
            }
            string = buffer.toString();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonUtils.closeQuietly(out);
                CommonUtils.closeQuietly(in);
                if (conn != null) {
                    conn.disconnect();
                }
                throw throwable;
            }
        }
        CommonUtils.closeQuietly(out);
        CommonUtils.closeQuietly(in);
        if (conn != null) {
            conn.disconnect();
        }
        return string;
    }

    public void setTolerance(long tolerance) {
        this.tolerance = tolerance;
    }

    static {
        try {
            DefaultBootstrap.bootstrap();
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

