/*
 * Decompiled with CFR 0.152.
 */
package com.sampullara.util;

import com.sampullara.mustache.Mustache;
import com.sampullara.mustache.MustacheTrace;
import com.sampullara.util.ImmediateFuture;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FutureWriter
extends Writer {
    private AppendableCallable last;
    private ConcurrentLinkedQueue<Future<Object>> ordered = new ConcurrentLinkedQueue();
    private static ExecutorService es;
    private Writer writer;
    private boolean closed = false;

    public static void setExecutorService(ExecutorService es) {
        ExecutorService old = FutureWriter.es;
        FutureWriter.es = es;
        old.shutdown();
    }

    public static ExecutorService getExecutorService() {
        return es;
    }

    public FutureWriter() {
    }

    public FutureWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public static void shutdown() {
        if (es != null) {
            es.shutdownNow();
        }
    }

    public void enqueue(CharSequence cs) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (this.last != null) {
            this.last.append(cs);
        } else {
            AppendableCallable call = new AppendableCallable(cs);
            this.enqueue(call);
            this.last = call;
        }
    }

    public void enqueue(Callable<Object> callable) throws IOException {
        Object future = es == null ? new ImmediateFuture<Object>(callable) : es.submit(callable);
        this.enqueue((Future<Object>)future);
    }

    public void enqueue(Future<Object> future) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.last = null;
        this.ordered.add(future);
    }

    @Override
    public void flush() throws IOException {
        this.flush(true);
    }

    public void flush(boolean top) throws IOException {
        try {
            for (Future<Object> work : this.ordered) {
                Object o;
                block9: {
                    try {
                        o = work.get(50L, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException te) {
                        MustacheTrace.Event flushEvent = null;
                        if (top && Mustache.trace) {
                            flushEvent = MustacheTrace.addEvent("flush_wait", "FutureWriter");
                        }
                        this.writer.flush();
                        o = work.get();
                        if (flushEvent == null) break block9;
                        flushEvent.start -= 50L;
                        flushEvent.end();
                    }
                }
                if (o instanceof FutureWriter) {
                    FutureWriter fw = (FutureWriter)o;
                    fw.setWriter(this.writer);
                    fw.flush(false);
                    continue;
                }
                if (o instanceof Future) {
                    Future future = (Future)o;
                    Object result = future.get();
                    if (result == null) continue;
                    this.writer.write(result.toString());
                    continue;
                }
                if (o == null) continue;
                this.writer.write(o.toString());
            }
            if (top) {
                this.writer.flush();
            }
            this.ordered.clear();
            this.last = null;
        }
        catch (Exception e) {
            throw new IOException("Failed to flush", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.writer.close();
        this.closed = true;
    }

    @Override
    public void write(int i) throws IOException {
        this.enqueue(String.valueOf((char)i));
    }

    @Override
    public void write(char[] chars, int i, int i1) throws IOException {
        this.enqueue(new String(chars, i, i1));
    }

    @Override
    public void write(String s, int i, int i1) throws IOException {
        this.enqueue(s.substring(i, i1));
    }

    @Override
    public void write(char[] chars) throws IOException {
        this.enqueue(new String(chars));
    }

    @Override
    public void write(String s) throws IOException {
        this.enqueue(s);
    }

    @Override
    public Writer append(CharSequence charSequence) throws IOException {
        this.enqueue(charSequence);
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int i, int i1) throws IOException {
        this.enqueue(charSequence.subSequence(i, i1));
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        this.enqueue(String.valueOf(c));
        return this;
    }

    static {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(10, 100, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10), new ThreadPoolExecutor.CallerRunsPolicy());
        executor.setThreadFactory(new ThreadFactory(){
            int i = 0;

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                thread.setName("Mustache-FutureWriter-" + this.i++);
                return thread;
            }
        });
        es = executor;
    }

    private static class AppendableCallable
    implements Appendable,
    Callable<Object> {
        StringBuffer sb;

        AppendableCallable(CharSequence cs) {
            this.sb = new StringBuffer(cs);
        }

        @Override
        public Appendable append(CharSequence cs) {
            this.sb.append(cs);
            return this;
        }

        @Override
        public Appendable append(CharSequence charSequence, int i, int i1) throws IOException {
            this.sb.append(charSequence, i, i1);
            return this;
        }

        @Override
        public Appendable append(char c) throws IOException {
            this.sb.append(String.valueOf(c));
            return this;
        }

        @Override
        public Object call() throws Exception {
            return this.sb;
        }
    }
}

